/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.conf.startup.support;

import com.huawei.fitframework.conf.startup.StartupConfig;
import com.huawei.fitframework.conf.startup.StartupConfigBuilder;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.MapUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class DefaultStartupConfig
implements StartupConfig {
    private final StartupConfig.Application application;
    private final StartupConfig.Worker worker;
    private final List<StartupConfig.Plugin> systemPlugins = new ArrayList<StartupConfig.Plugin>();
    private final List<StartupConfig.Plugin> userPlugins = new ArrayList<StartupConfig.Plugin>();

    private DefaultStartupConfig(StartupConfig.Application application, StartupConfig.Worker worker, List<StartupConfig.Plugin> systemPlugins, List<StartupConfig.Plugin> userPlugins) {
        this.application = application;
        this.worker = worker;
        this.systemPlugins.addAll(systemPlugins);
        this.systemPlugins.forEach(plugin -> {
            Integer cfr_ignored_0 = (Integer)Validation.between((Comparable)Integer.valueOf(plugin.level()), (Comparable)Integer.valueOf(-6), (Comparable)Integer.valueOf(0), (String)"System plugin level is out of range. [plugin={0}, level={1}]", (Object[])new Object[]{plugin.name(), plugin.level()});
        });
        this.userPlugins.addAll(userPlugins);
        this.userPlugins.forEach(plugin -> {
            Integer cfr_ignored_0 = (Integer)Validation.between((Comparable)Integer.valueOf(plugin.level()), (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6), (String)"User plugin level is out of range. [plugin={0}, level={1}]", (Object[])new Object[]{plugin.name(), plugin.level()});
        });
    }

    @Override
    public StartupConfig.Application application() {
        return this.application;
    }

    @Override
    public StartupConfig.Worker worker() {
        return this.worker;
    }

    @Override
    public List<StartupConfig.Plugin> systemPlugins() {
        return Collections.unmodifiableList(this.systemPlugins);
    }

    @Override
    public List<StartupConfig.Plugin> userPlugins() {
        return Collections.unmodifiableList(this.userPlugins);
    }

    @Override
    public List<StartupConfig.Plugin> allPlugins() {
        return Collections.unmodifiableList(CollectionUtils.connect((List[])new List[]{this.systemPlugins, this.userPlugins}));
    }

    @Override
    public List<Integer> getLevels() {
        return this.allPlugins().stream().map(StartupConfig.Plugin::level).distinct().collect(Collectors.toList());
    }

    @Override
    public List<StartupConfig.Plugin> getPlugins(int level) {
        return this.allPlugins().stream().filter(plugin -> plugin.level() == level).collect(Collectors.toList());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultStartupConfig)) {
            return false;
        }
        DefaultStartupConfig other = (DefaultStartupConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StartupConfig.Application this$application = this.application;
        StartupConfig.Application other$application = other.application;
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        StartupConfig.Worker this$worker = this.worker;
        StartupConfig.Worker other$worker = other.worker;
        if (this$worker == null ? other$worker != null : !this$worker.equals(other$worker)) {
            return false;
        }
        List<StartupConfig.Plugin> this$systemPlugins = this.systemPlugins;
        List<StartupConfig.Plugin> other$systemPlugins = other.systemPlugins;
        if (this$systemPlugins == null ? other$systemPlugins != null : !((Object)this$systemPlugins).equals(other$systemPlugins)) {
            return false;
        }
        List<StartupConfig.Plugin> this$userPlugins = this.userPlugins;
        List<StartupConfig.Plugin> other$userPlugins = other.userPlugins;
        return !(this$userPlugins == null ? other$userPlugins != null : !((Object)this$userPlugins).equals(other$userPlugins));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultStartupConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StartupConfig.Application $application = this.application;
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        StartupConfig.Worker $worker = this.worker;
        result = result * 59 + ($worker == null ? 43 : $worker.hashCode());
        List<StartupConfig.Plugin> $systemPlugins = this.systemPlugins;
        result = result * 59 + ($systemPlugins == null ? 43 : ((Object)$systemPlugins).hashCode());
        List<StartupConfig.Plugin> $userPlugins = this.userPlugins;
        result = result * 59 + ($userPlugins == null ? 43 : ((Object)$userPlugins).hashCode());
        return result;
    }

    public static class Builder
    implements StartupConfigBuilder {
        private StartupConfig.Application application;
        private StartupConfig.Worker worker;
        private final List<StartupConfig.Plugin> systemPlugins = new ArrayList<StartupConfig.Plugin>();
        private final List<StartupConfig.Plugin> userPlugins = new ArrayList<StartupConfig.Plugin>();

        public Builder(StartupConfig config) {
            if (config != null) {
                this.application = config.application();
                this.worker = config.worker();
                this.systemPlugins.addAll(config.systemPlugins());
                this.userPlugins.addAll(config.userPlugins());
            }
        }

        public Builder(Map<String, Object> map) {
            if (MapUtils.isEmpty(map)) {
                return;
            }
            this.application = StartupConfig.Application.build((Map)map.get("app")).build();
            this.worker = StartupConfig.Worker.build((Map)map.get("worker")).build();
            Map pluginsConfig = (Map)map.get("plugins");
            if (MapUtils.isNotEmpty((Map)pluginsConfig)) {
                this.systemPlugins.addAll(this.getPlugins((List)pluginsConfig.get("system-plugins"), this.worker.directory(), 0));
                this.userPlugins.addAll(this.getPlugins((List)pluginsConfig.get("user-plugins"), this.worker.directory(), 3));
            }
        }

        private List<StartupConfig.Plugin> getPlugins(List<Map<String, Object>> pluginsConfig, String workerDirectory, int defaultLevel) {
            if (CollectionUtils.isEmpty(pluginsConfig)) {
                return Collections.emptyList();
            }
            return pluginsConfig.stream().map(map -> StartupConfig.Plugin.build(map, workerDirectory, defaultLevel).build()).collect(Collectors.toList());
        }

        @Override
        public StartupConfigBuilder application(StartupConfig.Application application) {
            this.application = application;
            return this;
        }

        @Override
        public StartupConfigBuilder worker(StartupConfig.Worker worker) {
            this.worker = worker;
            return this;
        }

        @Override
        public StartupConfigBuilder addSystemPlugin(StartupConfig.Plugin plugin) {
            this.systemPlugins.add(plugin);
            return this;
        }

        @Override
        public StartupConfigBuilder addSystemPlugins(Collection<StartupConfig.Plugin> plugins) {
            this.systemPlugins.addAll(plugins);
            return this;
        }

        @Override
        public StartupConfigBuilder addUserPlugin(StartupConfig.Plugin plugin) {
            this.userPlugins.add(plugin);
            return this;
        }

        @Override
        public StartupConfigBuilder addUserPlugins(Collection<StartupConfig.Plugin> plugins) {
            this.userPlugins.addAll(plugins);
            return this;
        }

        @Override
        public StartupConfig build() {
            return new DefaultStartupConfig(this.application, this.worker, this.systemPlugins, this.userPlugins);
        }
    }
}

