/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.system;

import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.runtime.FitRuntimeException;
import java.net.URLClassLoader;
import java.util.Objects;

public class SystemClassLoaderContainer {
    private static final String FRAMEWORK_CLASS_LOADER_NAME = "FrameworkClassLoader";
    private static URLClassLoader sharedClassLoader;
    private static URLClassLoader frameworkClassLoader;
    private static volatile boolean initialized;

    public static void initialize() {
        if (initialized) {
            return;
        }
        frameworkClassLoader = SystemClassLoaderContainer.lookupFrameworkClassLoader();
        sharedClassLoader = (URLClassLoader)ObjectUtils.cast((Object)frameworkClassLoader.getParent());
        initialized = true;
    }

    private static URLClassLoader lookupFrameworkClassLoader() {
        ClassLoader currentClassLoader;
        for (currentClassLoader = Thread.currentThread().getContextClassLoader(); currentClassLoader != null && !Objects.equals(currentClassLoader.getClass().getSimpleName(), FRAMEWORK_CLASS_LOADER_NAME); currentClassLoader = currentClassLoader.getParent()) {
        }
        if (currentClassLoader == null) {
            throw new FitRuntimeException(StringUtils.format((String)"No {0}.", (Object[])new Object[]{FRAMEWORK_CLASS_LOADER_NAME}));
        }
        return (URLClassLoader)ObjectUtils.cast((Object)currentClassLoader);
    }

    public static URLClassLoader getSharedClassLoader() {
        return sharedClassLoader;
    }

    public static URLClassLoader getFrameworkClassLoader() {
        return frameworkClassLoader;
    }

    static {
        initialized = false;
    }
}

