/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.deploy.starter;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.nio.channels.FileLock;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context {
    private static final Logger log = LoggerFactory.getLogger(Context.class);
    private static FileOutputStream fos;
    private static FileLock fileLock;

    public static boolean lock() {
        try {
            fos = new FileOutputStream("runningFlag");
            fileLock = fos.getChannel().tryLock();
            return fileLock != null;
        }
        catch (Exception e) {
            log.error("init running flag failed.");
            return false;
        }
    }

    public static void releaseLock() {
        Optional.ofNullable(fileLock).ifPresent(Context::release);
        Optional.ofNullable(fos).ifPresent(Context::release);
    }

    private static void release(AutoCloseable autoCloseable) {
        try {
            autoCloseable.close();
        }
        catch (FileNotFoundException e) {
            log.error("release closeable failed, file not found.");
        }
        catch (Exception exception) {
            log.error("release closeable failed.", (Throwable)exception);
        }
    }

    private Context() {
    }
}

