/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.deploy.starter;

import com.huawei.encryptbase.context.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.yinglong.bpm.util.PortCheckUtil;
import com.huawei.yinglong.distributed.deploy.starter.Context;
import com.huawei.yinglong.distributed.deploy.starter.ProcessApplication;
import com.huawei.yinglong.distributed.deploy.starter.RouteSelector;
import com.huawei.yinglong.smartkit.base.util.SystemEnvUtil;
import com.huawei.yinglong.smartkit.frame.util.CertsUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;

public class DistributeServiceStart {
    private static final Logger log = LoggerFactory.getLogger(DistributeServiceStart.class);

    public static void main(String ... args) {
        if (DistributeServiceStart.checkPortAvailable()) {
            return;
        }
        RouteSelector.initEnvByScene();
        DistributeServiceStart.initLogDir();
        DistributeServiceStart.initRunningLock();
        String kmcConfigPath = System.getenv("kmcConfigPath");
        if (!StringUtils.isNULLStr((String)kmcConfigPath)) {
            ApplicationContext.getInstance().setAppEncryptConfigPath(kmcConfigPath);
        }
        if (!CertsUtil.generateDefaultSelfSignedCerts()) {
            CertsUtil.clearDefaultSelfSignedCerts();
            log.error("generate default self sign cert failed.");
            return;
        }
        CompletableFuture.runAsync(DistributeServiceStart::startBrowser);
        SpringApplication.run(ProcessApplication.class, (String[])args);
    }

    private static void initRunningLock() {
        if (!Context.lock()) {
            log.error("Get running flag lock failed. exit tool");
            Context.releaseLock();
            Runtime.getRuntime().exit(1);
        }
    }

    private static void initLogDir() {
        File logDir = new File("log");
        logDir.mkdirs();
    }

    private static boolean checkPortAvailable() {
        String serverPort = PortCheckUtil.getYamlPropertyValue((String)"server.port");
        if (!PortCheckUtil.isPortAvailable((int)Integer.parseInt(serverPort))) {
            log.error("port has been used.");
            return true;
        }
        return false;
    }

    private static void startBrowser() {
        try {
            String browser = Paths.get(SystemEnvUtil.getDefaultUserDir(), "electron", "ftd-browser.exe").toString();
            ProcessBuilder builder = new ProcessBuilder("cmd.exe", "/c", "\"" + browser + "\"", "common", RouteSelector.getRouteParam4Electron());
            String token = SystemEnvUtil.createSmartKitToken();
            SystemEnvUtil.saveSmartkitToken((String)token);
            builder.environment().put("token", token);
            builder.redirectErrorStream(true);
            Process process = builder.start();
            while (process.isAlive()) {
                Thread.sleep(1000L);
                DistributeServiceStart.refreshOutput(process.getInputStream());
            }
        }
        catch (Exception e) {
            log.info("Error exec!");
        }
    }

    private static void refreshOutput(InputStream is) throws IOException {
        int len;
        if (is == null) {
            return;
        }
        while ((len = is.available()) > 0) {
            byte[] bs = new byte[len];
            int bSize = is.read(bs);
            String outputStr = new String(bs, 0, bSize, Charset.defaultCharset());
            log.info("browser : {}", (Object)outputStr);
        }
    }
}

