/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.deploy.starter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class RouteSelector {
    private static final String ROUTE_PARAM_PREFIX = "route=";

    public static String getRouteParam4Electron() {
        return ROUTE_PARAM_PREFIX + RouteSelector.parseScene().getRouteName();
    }

    public static List<String> getCamundaTasks() {
        return RouteSelector.parseScene().getCamundaTasks();
    }

    public static List<String> getAllCamundaTasks() {
        return Arrays.stream(DistributedScene.values()).flatMap(scene -> scene.getCamundaTasks().stream()).collect(Collectors.toList());
    }

    public static void initEnvByScene() {
        DistributedScene scene = RouteSelector.parseScene();
        RouteSelector.initEnvInExpansion(scene);
        RouteSelector.initEnvInDeploy(scene);
    }

    private static void initEnvInDeploy(DistributedScene scene) {
        if (scene != DistributedScene.DEPLOY) {
            return;
        }
        System.setProperty("framework.scene", "yinglong");
        System.setProperty("tool.standalone.start", "true");
    }

    private static void initEnvInExpansion(DistributedScene scene) {
        if (scene != DistributedScene.EXPANSION) {
            return;
        }
        System.setProperty("framework.scene", "yinglong");
        System.setProperty("tool.standalone.start", "true");
    }

    private static DistributedScene parseScene() {
        return DistributedScene.getRouteByScene(System.getenv("jsonScene"));
    }

    private static enum DistributedScene {
        EXPANSION("expansion", "Fusionstorage Expansion Evaluation", Arrays.asList("distribute-expansion", "distribute-lld-collect", "distribute-node-initial")),
        DEPLOY("deploy", "Distributed Deploy,OceanProtect Deploy,HPDADeploy_genesequencing,HPDADeploy_edueesearch,HPDADeploy_edueesearch110,HPDADeploy_genesequencing110,RECOVERYDeploy_disasterrecovery", Arrays.asList("distribute-deploy-inspect", "distribute-node-initial", "distribute-hardware-config", "distribute-node-version-check", "distribute-upgrade", "distribute-system-installation", "storage-software-installation"));

        private final String routeName;
        private final String sceneNames;
        private final List<String> camundaTasks;

        public static DistributedScene getRouteByScene(String jsonScene) {
            return Arrays.stream(DistributedScene.values()).filter(scene -> Arrays.stream(scene.sceneNames.split(",")).anyMatch(jsonScene::contains)).findFirst().orElse(EXPANSION);
        }

        private DistributedScene(String routeName, String sceneNames, List<String> camundaTasks) {
            this.routeName = routeName;
            this.sceneNames = sceneNames;
            this.camundaTasks = camundaTasks;
        }

        public String getRouteName() {
            return this.routeName;
        }

        public String getSceneNames() {
            return this.sceneNames;
        }

        public List<String> getCamundaTasks() {
            return this.camundaTasks;
        }
    }
}

