/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.collect.bpm;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.dto.ProcessConfig;
import com.huawei.yinglong.bpm.exception.ActiveDelegateException;
import com.huawei.yinglong.bpm.util.ResponseUtil;
import com.huawei.yinglong.distributed.collect.entity.CollectActiveResult;
import com.huawei.yinglong.distributed.collect.entity.request.LldCollectParams;
import com.huawei.yinglong.distributed.entity.ResultStatus;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.rest.entity.Result;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.CollectLldInfo;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.QueryTaskOverView;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.entity.CollectLldDevParam;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.entity.MultiCollectDevOverViewDTO;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.spring.boot.starter.ClientProperties;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;

@Fitable
public class LldCollectTask
implements JavaDelegate {
    private static final Logger log = LoggerFactory.getLogger(LldCollectTask.class);
    @Fit(alias="queryTaskOverView\u7684\u5b9e\u73b0")
    private QueryTaskOverView queryTaskOverView;
    @Fit(alias="collectLldInfo\u7684\u5b9e\u73b01")
    private CollectLldInfo collectLldInfo;
    protected String workerId;
    private final RuntimeService runtimeService;
    private final BpmContextService bpmContextService;

    public LldCollectTask(ClientProperties properties, RuntimeService runtimeService, BpmContextService bpmContextService) {
        this.workerId = properties.getWorkerId();
        this.runtimeService = runtimeService;
        this.bpmContextService = bpmContextService;
    }

    public void execute(DelegateExecution delegateExecution) throws Exception {
        Response response;
        String executionId = delegateExecution.getId();
        ProcessConfig processConfig = (ProcessConfig)this.bpmContextService.getContext(executionId, ProcessConfig.class, "context", null);
        LldCollectParams params = (LldCollectParams)this.bpmContextService.getContext(executionId, LldCollectParams.class);
        if (processConfig != null) {
            params.setReportDir(processConfig.getReportDir());
        }
        if (ResponseUtil.isFailed((Response)(response = this.collectLldInfo.process(this.builderParam(delegateExecution, params))))) {
            Result result = response.getResult();
            throw new ActiveDelegateException(result.getCode().intValue(), result.getDescription(), result.getSuggestion());
        }
    }

    @ExternalTaskSubscription(value="queryLldOverview", lockDuration=2000L)
    @Bean
    public ExternalTaskHandler queryLldOverview() {
        return (externalTask, externalTaskService) -> {
            String taskId = externalTask.getProcessInstanceId();
            MultiCollectDevOverViewDTO overView = (MultiCollectDevOverViewDTO)this.queryTaskOverView.process(taskId).getData();
            ActivityResult activeResult = ((CollectActiveResult.CollectActiveResultBuilder)((Object)((Object)((CollectActiveResult.CollectActiveResultBuilder)((Object)((Object)((CollectActiveResult.CollectActiveResultBuilder)((Object)((Object)CollectActiveResult.builder().progress(CollectActiveResult.calcProgress(overView))))).status(CollectActiveResult.mergeStatus(overView))))).overView(overView)))).build();
            this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), activeResult);
            this.updateActiveStatus(externalTask, externalTaskService, activeResult.getStatus());
            this.bpmContextService.setProgress(externalTask.getExecutionId(), (int)activeResult.getProgress());
        };
    }

    private void updateActiveStatus(ExternalTask externalTask, ExternalTaskService externalTaskService, ResultStatus status) {
        if (status.isSuccess()) {
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
            return;
        }
        if (status.isFailed()) {
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
            return;
        }
    }

    private CollectLldDevParam builderParam(DelegateExecution delegateExecution, LldCollectParams params) {
        return CollectLldDevParam.builder().taskId(delegateExecution.getProcessInstanceId()).resultDir(params.getReportDir()).devIds(params.getSelectedClusterIds()).build();
    }
}

