/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.collect.controller;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.storage.entity.MultiStroageNodeDto;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.ExportCollectResult;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.QueryCollectDetail;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.QueryDevice;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.entity.CollectDevDetailDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"collection"})
public class InfoCollectController {
    private static final Logger log = LoggerFactory.getLogger(InfoCollectController.class);
    @Fit(alias="queryCollectDeatil_hardware")
    private QueryCollectDetail queryHardwareCollectDetail;
    @Fit(alias="exportCollectResult\u7684\u5b9e\u73b0")
    private ExportCollectResult exportCollectResult;
    @Fit(alias="queryCollectDeatil\u7684\u5b9e\u73b01")
    private QueryCollectDetail queryCollectDetail;
    @Fit(alias="queryDevice\u7684\u5b9e\u73b01")
    private QueryDevice queryDevice;

    @GetMapping(value={"device"})
    public Response<MultiStroageNodeDto> queryDevice(String taskId) {
        return this.queryDevice.process(taskId);
    }

    @GetMapping(value={"detail"})
    public Response<CollectDevDetailDTO> queryCollectDetail(String taskId, String devId) {
        return this.queryCollectDetail.process(taskId, devId);
    }

    @GetMapping(value={"result"})
    public Response<String> openResultDir(String taskId) {
        log.info("[info collect] start to open result dir task id : {}.", (Object)taskId);
        Response response = this.exportCollectResult.process(taskId);
        log.info("[info collect] end to open result dir result : {}.", (Object)response);
        return response;
    }

    @GetMapping(value={"hardware/detail"})
    public Response<CollectDevDetailDTO> queryHardwareCollectDetail(String taskId, String devId) {
        return this.queryHardwareCollectDetail.process(taskId, String.join((CharSequence)"_", taskId, devId));
    }
}

