/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.plugin.support;

import com.huawei.fitframework.broker.BundleIdentity;
import com.huawei.fitframework.broker.client.ioc.FitableComponentResolver;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.client.proxy.ProxyRepository;
import com.huawei.fitframework.conf.Config;
import com.huawei.fitframework.conf.ConfigUnit;
import com.huawei.fitframework.core.common.util.ClassNamePackageFilter;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.ioc.ComponentContainer;
import com.huawei.fitframework.ioc.ComponentRegistry;
import com.huawei.fitframework.ioc.ComponentResolver;
import com.huawei.fitframework.ioc.ComponentScanner;
import com.huawei.fitframework.ioc.support.DefaultComponentScanner;
import com.huawei.fitframework.plugin.Plugin;
import com.huawei.fitframework.plugin.PluginInstaller;
import com.huawei.fitframework.plugin.PluginManager;
import com.huawei.fitframework.plugin.support.DefaultPlugin;
import com.huawei.fitframework.plugin.util.ClassLoaderUtils;
import com.huawei.fitframework.plugin.util.PluginConfigUtils;
import com.huawei.fitframework.system.SystemClassLoaderContainer;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public abstract class AbstractPluginInstaller
implements PluginInstaller {
    private static final String DEFAULT_CONF_DIRECTORY = "conf";
    private static final String DEFAULT_CONF_FILE_NAME = "application.yml";
    private final ComponentContainer container;

    protected AbstractPluginInstaller(ComponentContainer container) {
        this.container = (ComponentContainer)Validation.notNull((Object)container, (String)"Component container to start plugin cannot be null.", (Object[])new Object[0]);
    }

    public Plugin install() {
        this.loadConfigUnit();
        this.loadComponents();
        List<BundleIdentity> localFitableIdentities = this.resolveLocalFitableIdentities();
        return this.instantiatePlugin(localFitableIdentities);
    }

    private void loadConfigUnit() {
        File configFile = FileUtils.child((File)this.getPluginDirectory(), (String[])new String[]{DEFAULT_CONF_DIRECTORY, DEFAULT_CONF_FILE_NAME});
        ConfigUnit baseConfigUnit = PluginConfigUtils.loadConfigUnit(configFile, this.getClassLoader(), DEFAULT_CONF_FILE_NAME);
        ConfigUnit pluginConfigUnit = ConfigUnit.combine((ConfigUnit)baseConfigUnit, (ConfigUnit)this.loadExtendedConfigUnit());
        ((Config)this.getContainer().require(Config.class, new Object[0])).installUnit(this.getClassLoader(), pluginConfigUnit);
    }

    private void loadComponents() {
        AbstractPluginInstaller.synchronizeSharedLibraries();
        ComponentScanner scanner = this.instantiateScanner();
        List<String> packageNames = this.getScanPackages();
        scanner.addClassNameFilter(ClassNamePackageFilter.create(packageNames));
        scanner.addComponentResolver((ComponentResolver)new FitableComponentResolver());
        ComponentRegistry registry = this.instantiateRegistry();
        scanner.scan(registry);
        registry.scan(new String[]{String.join((CharSequence)"", packageNames)});
    }

    protected ConfigUnit loadExtendedConfigUnit() {
        return null;
    }

    protected final <T> T require(Class<T> componentClass) {
        return (T)this.getContainer().require(componentClass, new Object[0]);
    }

    protected final PluginManager getManager() {
        return this.require(PluginManager.class);
    }

    protected Plugin instantiatePlugin(List<BundleIdentity> localFitableIdentities) {
        return new DefaultPlugin(this.container, this.getManager(), this.getClassLoader(), this.getPluginName(), this.getPluginDirectory(), localFitableIdentities);
    }

    protected ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected List<String> getScanPackages() {
        return PluginConfigUtils.getScanBasePackages(this.require(Config.class), this);
    }

    private static void synchronizeSharedLibraries() {
        URLClassLoader loader = SystemClassLoaderContainer.getSharedClassLoader();
        if (loader == null) {
            return;
        }
        Set jarUrls = Arrays.stream(loader.getURLs()).map(AbstractPluginInstaller::directory).distinct().flatMap(AbstractPluginInstaller::jars).collect(Collectors.toSet());
        HashSet<URL> originalUrls = new HashSet<URL>(Arrays.asList(loader.getURLs()));
        CollectionUtils.difference(jarUrls, originalUrls).forEach(jarUrl -> AbstractPluginInstaller.appendJarUrl(loader, jarUrl));
    }

    private static File directory(URL url) {
        File file;
        try {
            file = new File(url.toURI().getPath());
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(StringUtils.format((String)"Fail to convert URL to file. [url={0}]", (Object[])new Object[]{url.toExternalForm()}), ex);
        }
        return file.getParentFile();
    }

    private static Stream<URL> jars(File directory) {
        return Arrays.stream(ClassLoaderUtils.resolveJarUrls(directory));
    }

    private static void appendJarUrl(URLClassLoader loader, URL jarUrl) {
        Method method = ReflectionUtils.getDeclaredMethod(URLClassLoader.class, (String)"addURL", (Class[])new Class[]{URL.class});
        method.setAccessible(true);
        ReflectionUtils.invoke((Object)loader, (Method)method, (Object[])new Object[]{jarUrl});
    }

    protected abstract ComponentRegistry instantiateRegistry();

    protected ComponentScanner instantiateScanner() {
        return this.getContainer().get(ComponentScanner.Factory.class, new Object[0]).map(ComponentScanner.Factory.class::cast).orElseGet(DefaultComponentScanner.Factory::new).create(this.getClassLoader());
    }

    protected List<BundleIdentity> resolveLocalFitableIdentities() {
        ProxyFactory factory = this.require(ProxyFactory.class);
        return factory.getLocalProxyRepository(this.getPluginName()).map(ProxyRepository::getFitableIdentities).orElse(Collections.emptyList());
    }

    @Generated
    protected ComponentContainer getContainer() {
        return this.container;
    }
}

