/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.plugin.support;

import com.huawei.fitframework.broker.BundleIdentity;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.ioc.ComponentContainer;
import com.huawei.fitframework.ioc.ComponentFactory;
import com.huawei.fitframework.ioc.ComponentRegistry;
import com.huawei.fitframework.plugin.Plugin;
import com.huawei.fitframework.plugin.PluginManager;
import com.huawei.fitframework.runtime.PluginActivator;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPlugin
implements Plugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultPlugin.class);
    private final ComponentContainer container;
    private final PluginManager manager;
    private final ClassLoader classLoader;
    private final String name;
    private final File baseDirectory;
    private final List<BundleIdentity> localFitableIdentities;

    public DefaultPlugin(ComponentContainer container, PluginManager manager, ClassLoader classLoader, String name, File baseDirectory, List<BundleIdentity> localFitableIdentities) {
        this.container = container;
        this.manager = manager;
        this.classLoader = classLoader;
        this.name = name;
        this.baseDirectory = baseDirectory;
        this.localFitableIdentities = localFitableIdentities;
    }

    public List<BundleIdentity> getLocalFitableIdentities() {
        return Collections.unmodifiableList(this.localFitableIdentities);
    }

    public void resolve() {
        log.info("Prepare to resolve plugin. [plugin={}]", (Object)this.name);
        log.info("Plugin resolved. [plugin={}]", (Object)this.name);
    }

    public void start() {
        log.info("Prepare to start plugin. [plugin={}]", (Object)this.name);
        ComponentRegistry registry = (ComponentRegistry)this.container.getRegistry(this.name).orElseThrow(() -> new IllegalStateException(StringUtils.format((String)"No component registry. [registry={0}]", (Object[])new Object[]{this.name})));
        registry.getComponentFactory(PluginActivator.class).map(rec$ -> ((ComponentFactory)rec$).get(new Object[0])).map(PluginActivator.class::cast).ifPresent(PluginActivator::start);
        registry.preloadSingletons();
        registry.refresh();
        log.info("Plugin started. [plugin={}]", (Object)this.name);
    }

    public void stop() {
        log.info("Prepare to stop plugin. [plugin={}]", (Object)this.name);
        Optional optionalRegistry = this.container.getRegistry(this.name);
        if (!optionalRegistry.isPresent()) {
            log.debug("No component registry. [registry={}]", (Object)this.name);
            return;
        }
        ((ComponentRegistry)optionalRegistry.get()).getComponentFactory(PluginActivator.class).map(rec$ -> ((ComponentFactory)rec$).get(new Object[0])).map(PluginActivator.class::cast).ifPresent(PluginActivator::stop);
        log.info("Plugin stopped. [plugin={}]", (Object)this.name);
    }

    @Generated
    public PluginManager getManager() {
        return this.manager;
    }

    @Generated
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public File getBaseDirectory() {
        return this.baseDirectory;
    }
}

