/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.plugin.support;

import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.client.util.GenericableScanner;
import com.huawei.fitframework.broker.conf.BrokerConfigurationConfigurator;
import com.huawei.fitframework.broker.conf.ConfigurationLoader;
import com.huawei.fitframework.broker.conf.ConfigureMode;
import com.huawei.fitframework.conf.Config;
import com.huawei.fitframework.conf.ConfigUnit;
import com.huawei.fitframework.conf.startup.StartupConfig;
import com.huawei.fitframework.core.common.util.ClassNamePackageFilter;
import com.huawei.fitframework.core.common.util.ClassScanner;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.core.common.util.support.UrlClassLoaderScanner;
import com.huawei.fitframework.ioc.ComponentContainer;
import com.huawei.fitframework.ioc.ComponentRegistry;
import com.huawei.fitframework.ioc.ContainerType;
import com.huawei.fitframework.ioc.support.DefaultComponentRegistry;
import com.huawei.fitframework.plugin.Plugin;
import com.huawei.fitframework.plugin.loader.PluginClassLoader;
import com.huawei.fitframework.plugin.support.AbstractPluginInstaller;
import com.huawei.fitframework.plugin.support.PluginDirectoryConfigUnit;
import com.huawei.fitframework.runtime.SystemDirectories;
import com.huawei.fitframework.spring.FitBeanDefinitionRegistryPostProcessor;
import com.huawei.fitframework.spring.support.SpringComponentRegistry;
import com.huawei.fitframework.system.SystemClassLoaderContainer;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;

public class DefaultPluginInstaller
extends AbstractPluginInstaller {
    private static final String BASE_PACKAGE_CONFIG_KEY = "framework.scanner.filter.package";
    private final StartupConfig.Plugin plugin;
    private final PluginClassLoader classLoader;

    public DefaultPluginInstaller(ComponentContainer container, StartupConfig.Plugin plugin) {
        super(container);
        this.plugin = (StartupConfig.Plugin)Validation.notNull((Object)plugin, (String)"No plugin config for startup.", (Object[])new Object[0]);
        Validation.isTrue((boolean)this.plugin.file().isDirectory(), (String)"Plugin file is not a directory. [plugin={0}]", (Object[])new Object[]{plugin.name()});
        this.classLoader = PluginClassLoader.create(plugin);
    }

    public String getPluginName() {
        return this.plugin.name();
    }

    public File getPluginDirectory() {
        return this.plugin.file();
    }

    @Override
    protected ConfigUnit loadExtendedConfigUnit() {
        return new PluginDirectoryConfigUnit(this.getPluginDirectory());
    }

    @Override
    public Plugin install() {
        Plugin installedPlugin = super.install();
        this.loadGenericableConfigurations();
        this.synchronizeSharedClassLoader();
        return installedPlugin;
    }

    private void loadGenericableConfigurations() {
        ConfigurationLoader loader = (ConfigurationLoader)this.getContainer().require(ConfigurationLoader.class, new Object[0]);
        SystemDirectories.Plugin pluginDirectory = SystemDirectories.getPlugin((File)this.getPluginDirectory());
        BrokerConfigurationConfigurator configurator = BrokerConfigurationConfigurator.plugin((SystemDirectories.Plugin)pluginDirectory);
        loader.configure(configurator, ConfigureMode.APPEND);
    }

    @Override
    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    protected ComponentRegistry instantiateRegistry() {
        ComponentRegistry registry;
        ComponentContainer container = this.getContainer();
        String pluginName = this.getPluginName();
        ContainerType containerType = container.getContainerType();
        Validation.notNull((Object)containerType, (String)"Container type cannot be null.", (Object[])new Object[0]);
        switch (containerType) {
            case FIT: {
                registry = new DefaultComponentRegistry(container, pluginName);
                break;
            }
            case SPRING: {
                registry = this.createSpringRegistry(container, pluginName);
                break;
            }
            default: {
                throw new IllegalStateException(StringUtils.format((String)"Unsupported container type. [type={0}]", (Object[])new Object[]{containerType.getCode()}));
            }
        }
        container.installRegistry(registry);
        return registry;
    }

    private ComponentRegistry createSpringRegistry(ComponentContainer container, String pluginName) {
        ClassLoader loader = this.getClassLoader();
        SpringComponentRegistry springRegistry = new SpringComponentRegistry(container, pluginName, loader);
        springRegistry.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new FitBeanDefinitionRegistryPostProcessor(this.getScanPackages()));
        springRegistry.setClassLoader(loader);
        return springRegistry;
    }

    @Deprecated
    private void synchronizeSharedClassLoader() {
        ProxyFactory proxyFactory = this.require(ProxyFactory.class);
        UrlClassLoaderScanner classScanner = new UrlClassLoaderScanner(SystemClassLoaderContainer.getSharedClassLoader(), null);
        List packageNames = (List)this.require(Config.class).get((Object)this, BASE_PACKAGE_CONFIG_KEY);
        classScanner.addClassNameFilter(ClassNamePackageFilter.create((Collection)packageNames));
        GenericableScanner scanner = new GenericableScanner((ClassScanner)classScanner);
        scanner.scan();
        scanner.getGenericableClasses().values().forEach(arg_0 -> ((ProxyFactory)proxyFactory).registerGenericable(arg_0));
    }
}

