/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.plugin.support;

import com.huawei.fitframework.conf.Config;
import com.huawei.fitframework.conf.startup.StartupConfig;
import com.huawei.fitframework.core.common.util.LockUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.ioc.ComponentContainer;
import com.huawei.fitframework.plugin.Plugin;
import com.huawei.fitframework.plugin.PluginInstaller;
import com.huawei.fitframework.plugin.PluginManager;
import com.huawei.fitframework.plugin.support.DefaultPluginInstaller;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DefaultPluginManager
implements PluginManager {
    private final ComponentContainer container;
    private final ConcurrentMap<String, Plugin> plugins;
    private final ReadWriteLock lock;

    public DefaultPluginManager(ComponentContainer container) {
        this.container = (ComponentContainer)Validation.notNull((Object)container, (String)"Component container of a plugin manager cannot be null.", (Object[])new Object[0]);
        this.plugins = new ConcurrentHashMap<String, Plugin>();
        this.lock = LockUtils.newReentrantReadWriteLock();
    }

    public Plugin install(StartupConfig.Plugin plugin) {
        return this.install(new DefaultPluginInstaller(this.container, plugin));
    }

    public Plugin install(PluginInstaller pluginInstaller) {
        Validation.notNull((Object)pluginInstaller, (String)"The starter to start plugin cannot be null.", (Object[])new Object[0]);
        return (Plugin)LockUtils.synchronize((Lock)this.lock.writeLock(), () -> {
            this.get(pluginInstaller.getPluginName()).ifPresent(plugin -> this.stop(pluginInstaller.getPluginName()));
            Plugin plugin2 = pluginInstaller.install();
            this.plugins.put(plugin2.getName(), plugin2);
            return plugin2;
        });
    }

    public void stop(String pluginName) {
        LockUtils.synchronize((Lock)this.lock.writeLock(), () -> this.get(pluginName).ifPresent(this::stop));
    }

    private void stop(Plugin plugin) {
        this.container.getRegistry(plugin.getName()).ifPresent(arg_0 -> ((ComponentContainer)this.container).uninstallRegistry(arg_0));
        ((Config)this.container.require(Config.class, new Object[0])).uninstallUnit(plugin.getClassLoader());
    }

    public Optional<Plugin> get(String pluginName) {
        if (StringUtils.isBlank((String)pluginName)) {
            return Optional.empty();
        }
        return (Optional)LockUtils.synchronize((Lock)this.lock.readLock(), () -> Optional.ofNullable(this.plugins.get(pluginName)));
    }

    public List<Plugin> list() {
        return Collections.unmodifiableList(new ArrayList(this.plugins.values()));
    }
}

