/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.plugin.support;

import com.huawei.fitframework.broker.client.ioc.FitableComponentResolver;
import com.huawei.fitframework.core.common.util.ClassNamePackageFilter;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.ioc.ComponentContainer;
import com.huawei.fitframework.ioc.ComponentRegistry;
import com.huawei.fitframework.ioc.ComponentResolver;
import com.huawei.fitframework.ioc.ComponentScanner;
import com.huawei.fitframework.ioc.support.DefaultComponentScanner;
import com.huawei.fitframework.plugin.Plugin;
import com.huawei.fitframework.plugin.support.AbstractPluginInstaller;
import com.huawei.fitframework.plugin.util.FrameworkClassLoaderUtils;
import com.huawei.fitframework.runtime.SystemDirectories;
import java.io.File;
import java.net.URL;
import java.util.List;

public class FrameworkPluginInstaller
extends AbstractPluginInstaller {
    private final SystemDirectories.Framework frameworkDirectory;

    public FrameworkPluginInstaller(ComponentContainer container, SystemDirectories.Framework frameworkDirectory) {
        super(container);
        this.frameworkDirectory = (SystemDirectories.Framework)Validation.notNull((Object)frameworkDirectory, (String)"Directory of framework to start cannot be null.", (Object[])new Object[0]);
    }

    public String getPluginName() {
        return "proxy-repository:local";
    }

    public File getPluginDirectory() {
        return this.frameworkDirectory.root();
    }

    @Override
    public Plugin install() {
        FrameworkClassLoaderUtils.setUrlObserver(this::scanUrls);
        return super.install();
    }

    @Override
    protected ComponentRegistry instantiateRegistry() {
        return this.getContainer().getRegistry();
    }

    private void scanUrls(List<URL> addedUrls) {
        DefaultComponentScanner.Factory factory = new DefaultComponentScanner.Factory();
        ComponentScanner scanner = factory.create(this.getClassLoader());
        scanner.addComponentResolver((ComponentResolver)new FitableComponentResolver());
        scanner.addUrlFilter(addedUrls::contains);
        scanner.addClassNameFilter(ClassNamePackageFilter.create(this.getScanPackages()));
        scanner.scan(this.instantiateRegistry());
    }
}

