/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.plugin.util;

import com.huawei.fitframework.core.common.util.ArrayUtils;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.plugin.PluginLoadException;
import com.huawei.fitframework.runtime.SystemDirectories;
import com.huawei.fitframework.system.SystemClassLoaderContainer;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClassLoaderUtils.class);
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String METHOD_GET_URLS = "getURLs";
    private static final String METHOD_ADD_URL = "addURL";
    private static final String METHOD_ADD_URLS = "addUrls";
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";

    private static List<URL> findActualAddingUrls(URLClassLoader classLoader, URL ... urls) {
        Method getUrls = ReflectionUtils.getDeclaredMethod(URLClassLoader.class, (String)METHOD_GET_URLS, (Class[])new Class[0]);
        URL[] existUrls = (URL[])ReflectionUtils.invokeWithReturnType((Object)classLoader, (Method)getUrls, URL[].class, (Object[])new Object[0]);
        HashSet existUrlNames = existUrls == null ? new HashSet() : Stream.of(existUrls).filter(Objects::nonNull).map(FileUtils::file).map(File::getName).flatMap(fileName -> ClassLoaderUtils.equivalence(fileName).stream()).collect(Collectors.toSet());
        ArrayList<URL> toAddUrls = new ArrayList<URL>();
        Stream.of(urls).filter(Objects::nonNull).forEach(url -> ClassLoaderUtils.addNonExistUrl(existUrlNames, toAddUrls, url));
        return toAddUrls;
    }

    private static List<String> equivalence(String fileName) {
        String another = ClassLoaderUtils.isSnapshot(fileName) ? ClassLoaderUtils.getRelease(fileName) : ClassLoaderUtils.getSnapshot(fileName);
        return Arrays.asList(fileName, another);
    }

    private static String getSnapshot(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf(JAR_FILE_EXTENSION)) + SNAPSHOT_SUFFIX + JAR_FILE_EXTENSION;
    }

    private static String getRelease(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf(SNAPSHOT_SUFFIX)) + JAR_FILE_EXTENSION;
    }

    private static boolean isSnapshot(String fileName) {
        return fileName.contains(SNAPSHOT_SUFFIX);
    }

    private static void addNonExistUrl(Set<String> existUrlNames, List<URL> toAddUrls, URL url) {
        String fileName = FileUtils.file((URL)url).getName();
        if (existUrlNames.contains(fileName)) {
            return;
        }
        existUrlNames.add(fileName);
        toAddUrls.add(url);
    }

    private static void addUrl2Shared(URL url) {
        Method addURL = ReflectionUtils.getDeclaredMethod(SystemClassLoaderContainer.getSharedClassLoader().getClass(), (String)METHOD_ADD_URL, (Class[])new Class[]{URL.class});
        ReflectionUtils.invoke((Object)SystemClassLoaderContainer.getSharedClassLoader(), (Method)addURL, (Object[])new Object[]{url});
    }

    private static void addUrls2Framework(List<URL> urls) {
        Method addUrls = ReflectionUtils.getDeclaredMethod(SystemClassLoaderContainer.getFrameworkClassLoader().getClass(), (String)METHOD_ADD_URLS, (Class[])new Class[]{List.class});
        ReflectionUtils.invoke((Object)SystemClassLoaderContainer.getFrameworkClassLoader(), (Method)addUrls, (Object[])new Object[]{urls});
    }

    public static URL[] resolveJarUrls(File ... directories) {
        Validation.notNull((Object)directories, (String)"Directories to resolve jars cannot be null.", (Object[])new Object[0]);
        ArrayList urls = new ArrayList();
        Stream.of(directories).filter(Objects::nonNull).forEach(directory -> ClassLoaderUtils.resolveJarUrls(urls, directory));
        return urls.toArray(new URL[0]);
    }

    private static void resolveJarUrls(List<URL> urls, File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    ClassLoaderUtils.resolveJarUrls(urls, file);
                    continue;
                }
                ClassLoaderUtils.resolveJarUrl(urls, file);
            }
        }
    }

    private static void resolveJarUrl(List<URL> urls, File file) {
        if (file.getName().endsWith(JAR_FILE_EXTENSION)) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new PluginLoadException("Fail to transfer Jar file to URL.", (Throwable)e);
            }
        }
    }

    public static void addExtensions() {
        log.info("Start to add extensions.");
        HashSet extensionNames = new HashSet();
        CollectionUtils.connect((List[])new List[]{SystemDirectories.framework().platform().extensions(), SystemDirectories.extensions()}).stream().peek(extension -> ClassLoaderUtils.log(StringUtils.format((String)"Start to add extension[{0}].", (Object[])new Object[]{extension.name()}))).filter(extension -> ClassLoaderUtils.isExtensionNotAdded(extension, extensionNames)).forEach(ClassLoaderUtils::addExtensionIncludeShared);
        log.info("Total {} extensions added.", (Object)extensionNames.size());
    }

    private static void log(String message) {
        log.info("{}", (Object)message);
    }

    private static boolean isExtensionNotAdded(SystemDirectories.Extension extension, Set<String> extensionNames) {
        if (extensionNames.contains(extension.name())) {
            log.info("Duplicated extension[{}], skipped.", (Object)extension.name());
            return false;
        }
        extensionNames.add(extension.name());
        return true;
    }

    private static void addExtensionIncludeShared(SystemDirectories.Extension extension) {
        ClassLoaderUtils.addShared(extension.shared());
        ClassLoaderUtils.addExtension(extension);
    }

    public static void addPlugin(SystemDirectories.Plugin plugin) {
        ClassLoaderUtils.addShared(plugin.shared());
        ClassLoaderUtils.addPluginConverter(plugin);
    }

    private static void addShared(SystemDirectories.Shared shared) {
        URL[] urls = ClassLoaderUtils.resolveJarUrls(shared.root());
        ClassLoaderUtils.addUrls2Shared(urls);
    }

    private static void addExtension(SystemDirectories.Extension extension) {
        URL[] urls = ClassLoaderUtils.resolveJarUrls(extension.lib(), extension.thirdParty(), extension.platform().converter());
        ClassLoaderUtils.addUrls2Framework(urls);
    }

    private static void addPluginConverter(SystemDirectories.Plugin plugin) {
        URL[] urls = ClassLoaderUtils.resolveJarUrls(plugin.platform().converter());
        ClassLoaderUtils.addUrls2Framework(urls);
    }

    private static void addUrls2Shared(URL[] urls) {
        List<URL> addedUrls;
        Stream.of(urls).forEach(url -> ClassLoaderUtils.log(StringUtils.format((String)"Url[{0}] prepare to add to Shared.", (Object[])new Object[]{url.getFile()})));
        log.info("Total {} urls prepare to add to Shared.", (Object)urls.length);
        if (ArrayUtils.isEmpty((Object[])urls)) {
            addedUrls = Collections.emptyList();
        } else {
            List<URL> toAddUrls = ClassLoaderUtils.findActualAddingUrls(SystemClassLoaderContainer.getSharedClassLoader(), urls);
            toAddUrls.forEach(ClassLoaderUtils::addUrl2Shared);
            addedUrls = toAddUrls;
        }
        addedUrls.forEach(url -> ClassLoaderUtils.log(StringUtils.format((String)"Url[{0}] added to Shared.", (Object[])new Object[]{url.getFile()})));
        log.info("Total {} extra urls added to Shared.", (Object)addedUrls.size());
    }

    private static void addUrls2Framework(URL[] urls) {
        List<Object> addedUrls;
        Stream.of(urls).forEach(url -> ClassLoaderUtils.log(StringUtils.format((String)"Url[{0}] prepare to add to Framework.", (Object[])new Object[]{url.getFile()})));
        log.info("Total {} urls prepare to add to Framework.", (Object)urls.length);
        if (ArrayUtils.isEmpty((Object[])urls)) {
            addedUrls = Collections.emptyList();
        } else {
            List<URL> toAddUrls = ClassLoaderUtils.findActualAddingUrls(SystemClassLoaderContainer.getFrameworkClassLoader(), urls);
            ClassLoaderUtils.addUrls2Framework(toAddUrls);
            addedUrls = toAddUrls;
        }
        addedUrls.forEach(url -> ClassLoaderUtils.log(StringUtils.format((String)"Url[{0}] added to Framework.", (Object[])new Object[]{url.getFile()})));
        log.info("Total {} extra urls added to Framework.", (Object)addedUrls.size());
    }
}

