/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.plugin.util;

import com.huawei.fitframework.conf.Config;
import com.huawei.fitframework.conf.ConfigUnit;
import com.huawei.fitframework.conf.util.ConfigLoader;
import com.huawei.fitframework.core.common.util.ArrayUtils;
import com.huawei.fitframework.core.common.util.IoUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginConfigUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginConfigUtils.class);
    private static final String BASE_PACKAGE_CONFIG_KEY = "framework.scanner.filter.package";

    private PluginConfigUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigUnit loadConfigUnit(File configFile, ClassLoader loader, String resourceKey) {
        ConfigUnit unit;
        block21: {
            Validation.notNull((Object)configFile, (String)"The configuration file to load unit cannot be null.", (Object[])new Object[0]);
            Validation.notNull((Object)loader, (String)"The class loader to load configuration unit cannot be null.", (Object[])new Object[0]);
            Validation.notNull((Object)resourceKey, (String)"The resource key of configuration unit cannot be null.", (Object[])new Object[0]);
            unit = null;
            try {
                Enumeration<URL> urls = loader.getResources(resourceKey);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    InputStream in = url.openStream();
                    try {
                        unit = ConfigUnit.combine((ConfigUnit)PluginConfigUtils.loadConfigUnit(in, resourceKey), unit);
                    }
                    finally {
                        IoUtils.close((InputStream)in);
                    }
                }
            }
            catch (IOException e) {
                log.debug("Load config from resource error. [resource={}]", (Object)resourceKey, (Object)e);
            }
            if (configFile.exists()) {
                log.debug("Load config from file. [file={}]", (Object)configFile.getName());
                try (FileInputStream fin = new FileInputStream(configFile);){
                    unit = ConfigUnit.combine((ConfigUnit)ConfigLoader.fromYaml((InputStream)fin), (ConfigUnit)unit);
                    break block21;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Fail to load configuration file: " + configFile.getName(), e);
                }
            }
            log.debug("File not found. Skip to load file config. [file={}]", (Object)configFile.getName());
        }
        return unit;
    }

    private static ConfigUnit loadConfigUnit(InputStream in, String resourceKey) {
        if (in == null) {
            log.debug("Resource not found. Skip to load embedded config. [resource={}]", (Object)resourceKey);
            return null;
        }
        log.debug("Load embedded config. [resource={}]", (Object)resourceKey);
        return ConfigLoader.fromYaml((InputStream)in);
    }

    public static ConfigUnit resolveArgumentsConfigUnit(Map<String, String> keyValues) {
        log.debug("Total {} configs loaded from command line arguments. [keys={}]", (Object)keyValues.size(), keyValues.keySet());
        return keyValues::get;
    }

    public static List<String> getScanBasePackages(Config config, Object object) {
        Object scanPackages = config.get(object, BASE_PACKAGE_CONFIG_KEY);
        List packageList = scanPackages instanceof List ? (List)scanPackages : (scanPackages != null && scanPackages.getClass().isArray() ? Stream.of(ArrayUtils.concrete((Object)scanPackages)).collect(Collectors.toList()) : Collections.emptyList());
        return PluginConfigUtils.canonicalizePackages(packageList.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList()));
    }

    private static List<String> canonicalizePackages(List<String> packages) {
        return packages.stream().map(StringUtils::trim).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }
}

