/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cms.verify.bc;

import com.huawei.cms.verify.bc.CMSVerify;
import com.huawei.cms.verify.bc.CMSVerifyUtil;
import com.huawei.cms.verify.bc.CertWrapper;
import com.huawei.cms.verify.bc.CmscbbErr;
import com.huawei.cms.verify.bc.CommonUtil;
import com.huawei.cms.verify.bc.CrlWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Store;

public final class CMSVerifyTsUtil {
    private static final Logger LOGGER = Logger.getLogger(CMSVerify.class.getName());

    private CMSVerifyTsUtil() {
    }

    public static void verifyTSPMatchCMS(SignerInformationVerifier verifier, CMSTypedData content, TimeStampToken tspToken) throws AnnotatedException, OperatorCreationException, CMSException {
        byte[] resultDigest = null;
        DigestCalculator calc = verifier.getDigestCalculator(tspToken.getTimeStampInfo().getHashAlgorithm());
        OutputStream digOut = calc.getOutputStream();
        if (digOut != null) {
            try {
                content.write(digOut);
                resultDigest = calc.getDigest();
            }
            catch (IOException | CMSException e) {
                throw new CMSException("write output stream failed.");
            }
            finally {
                try {
                    digOut.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Close output stream failed.");
                }
            }
        }
        if (resultDigest == null || !Arrays.constantTimeAreEqual((byte[])resultDigest, (byte[])tspToken.getTimeStampInfo().getMessageImprintDigest())) {
            throw new AnnotatedException("MessageImprint digest value does not match calculated value.");
        }
    }

    public static void checkTimestampCertChainWithoutEndCrl(CMSSignedData tspData, Date date, X509Certificate tsaEndCert, List<CertWrapper> certList, Map<X500Principal, CrlWrapper> crlMap) throws GeneralSecurityException, AnnotatedException {
        Store store = tspData.getCertificates();
        if (!(store instanceof CollectionStore)) {
            throw new AnnotatedException("Type conversion error!");
        }
        CollectionStore tspCerts = (CollectionStore)store;
        X509Certificate baseCheckCert = CommonUtil.getSignCert((CollectionStore<X509CertificateHolder>)tspCerts, tsaEndCert.getIssuerX500Principal(), certList);
        CommonUtil.checkCAUsage(baseCheckCert);
        if (date.before(baseCheckCert.getNotBefore()) || date.after(baseCheckCert.getNotAfter())) {
            throw new CertPathBuilderException(CmscbbErr.PKI_CERT_DATETIME_EXPIRED.toString());
        }
        CMSVerifyUtil.checkCAOfCrl(baseCheckCert, (CollectionStore<X509CertificateHolder>)tspCerts, date, certList, crlMap);
    }
}

