/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.certbase.integrity.pgp;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Objects;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpVerifyUtil {
    private static final Logger log = LoggerFactory.getLogger(PgpVerifyUtil.class);

    /*
     * Exception decompiling
     */
    public static boolean verifySignature(File targetFile, File signFile, File keyFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean verifySignature(File target, InputStream sigFileIn, InputStream keyIn) throws IOException, PGPException {
        sigFileIn = PGPUtil.getDecoderStream((InputStream)sigFileIn);
        JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(sigFileIn);
        PGPSignatureList ps = PgpVerifyUtil.getPgpSignatures(pgpFact);
        PGPPublicKeyRingCollection pgpPubRingCollection = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)keyIn), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PGPSignature sig = Objects.requireNonNull(ps).get(0);
        PGPPublicKey key = pgpPubRingCollection.getPublicKey(sig.getKeyID());
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            sig.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), Objects.requireNonNull(key));
        }
        catch (Exception e) {
            log.error("verifySignature error.", (Throwable)e);
            return false;
        }
        return PgpVerifyUtil.verifyFileSignature(target, sig);
    }

    private static PGPSignatureList getPgpSignatures(JcaPGPObjectFactory pgpFact) throws IOException, PGPException {
        PGPSignatureList ps;
        Object pc = pgpFact.nextObject();
        if (pc instanceof PGPCompressedData) {
            PGPCompressedData c1 = (PGPCompressedData)pc;
            pgpFact = new JcaPGPObjectFactory(c1.getDataStream());
            ps = (PGPSignatureList)pgpFact.nextObject();
        } else {
            ps = (PGPSignatureList)pc;
        }
        return ps;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean verifyFileSignature(File target, PGPSignature sig) {
        try (BufferedInputStream dIn = new BufferedInputStream(new FileInputStream(target));){
            int ch;
            while ((ch = ((InputStream)dIn).read()) >= 0) {
                sig.update((byte)ch);
            }
            boolean bl = sig.verify();
            return bl;
        }
        catch (IOException e) {
            log.error("Read input file error.");
            return false;
        }
        catch (PGPException e) {
            log.error("Verify input file error.", (Throwable)e);
        }
        return false;
    }
}

