/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.launch;

import com.huawei.fitframework.launch.exception.FitFrameworkStartupException;
import com.huawei.fitframework.launch.loader.ClassLoaderSupplier;
import com.huawei.fitframework.launch.loader.FrameworkClassLoader;
import com.huawei.fitframework.launch.loader.SharedClassLoader;
import com.huawei.fitframework.launch.loader.support.DefaultClassLoaderSupplier;
import com.huawei.fitframework.launch.timer.StartupTimer;
import com.huawei.fitframework.launch.timer.support.DefaultStartupTimer;
import com.huawei.fitframework.launch.util.ClassLoaderUtils;
import com.huawei.fitframework.launch.util.FileUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FitLauncher {
    private static final List<String> DEFAULT_PARENT_CLASS_LOADER_NAMES = Arrays.asList("ExtClassLoader", "PlatformClassLoader");
    private static final String KEY_FRAMEWORK_ROOT_FOLDER = "framework.directory";
    private static final String KEY_SHARED_DIRECTORIES = "shared.directories";
    private static final String KEY_SHARED_PARENT_CLASSLOADER = "shared.parent.classloader";
    private static final String SEPARATOR_KEY_VALUE = "=";
    private static final String VALUE_SEPARATOR = ",";
    private static final String SHARED_PARENT_FOLDER = "shared";
    private static final String FRAMEWORK_PARENT_FOLDER = "platform";
    private static final List<String> FRAMEWORK_FOLDERS = Arrays.asList("converter", "lib", "third-party");
    private static final String RUNTIME_CLASS_NAME = "com.huawei.fitframework.runtime.FitRuntime";
    private static final String MAIN = "start";
    private static final String DATA_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss,SSS";
    private final ClassLoader frameworkClassLoader;
    private final ClassLoaderSupplier classLoaderSupplier;

    FitLauncher(String[] args, ClassLoader sharedClassLoader, ClassLoaderSupplier classLoaderSupplier) {
        this.classLoaderSupplier = classLoaderSupplier;
        this.frameworkClassLoader = this.getFrameworkClassLoader(args, sharedClassLoader);
    }

    public static void main(String[] args) {
        try {
            FitLauncher.start(args, null);
        }
        catch (FitFrameworkStartupException e) {
            System.err.printf(Locale.ROOT, "%s %s ERROR %s%n", LocalDateTime.now().format(DateTimeFormatter.ofPattern(DATA_TIME_PATTERN)), Thread.currentThread().getName(), e.getMessage());
            System.exit(-1);
        }
    }

    public static Object start(String[] args, ClassLoader sharedClassLoader) {
        try (DefaultStartupTimer timer = new DefaultStartupTimer();){
            Object object = FitLauncher.start(args, sharedClassLoader, timer);
            return object;
        }
    }

    private static Object start(String[] args, ClassLoader sharedClassLoader, StartupTimer timer) {
        String[] actualArgs = args != null ? args : new String[]{};
        FitLauncher launcher = new FitLauncher(actualArgs, sharedClassLoader, new DefaultClassLoaderSupplier());
        return launcher.getEntryClass().flatMap(launcher::getEntryMethod).filter(launcher::isStatic).map(method -> launcher.invoke((Method)method, timer.getStartTime(), actualArgs)).orElse(null);
    }

    private ClassLoader getFrameworkClassLoader(String[] args, ClassLoader sharedClassLoader) {
        ClassLoader actualSharedClassLoader = sharedClassLoader != null ? sharedClassLoader : this.getSharedClassLoader(args);
        return this.createFrameworkClassLoader(this.getFrameworkFolder(args), actualSharedClassLoader);
    }

    private ClassLoader getSharedClassLoader(String[] args) {
        return this.createSharedClassLoader(this.getFrameworkFolder(args), this.getSharedFolders(args), this.getParentClassloaderNames(args));
    }

    private String getFrameworkFolder(String[] args) {
        return this.getArgByCondition(args, arg -> arg.startsWith("framework.directory=")).orElse(".");
    }

    private List<String> getSharedFolders(String[] args) {
        return this.getArgByCondition(args, arg -> arg.startsWith("shared.directories=")).map(sharedDirectories -> Arrays.stream(sharedDirectories.split(VALUE_SEPARATOR)).filter(Objects::nonNull).filter(sharedDirectory -> !sharedDirectory.isEmpty()).collect(Collectors.toList())).orElseGet(ArrayList::new);
    }

    private List<String> getParentClassloaderNames(String[] args) {
        return this.getArgByCondition(args, arg -> arg.startsWith("shared.parent.classloader=")).map(classloaderNames -> Arrays.stream(classloaderNames.split(VALUE_SEPARATOR)).filter(Objects::nonNull).filter(classLoaderName -> !classLoaderName.isEmpty()).collect(Collectors.toList())).orElse(DEFAULT_PARENT_CLASS_LOADER_NAMES);
    }

    private Optional<String> getArgByCondition(String[] args, Predicate<String> predicate) {
        return Stream.of(args).filter(Objects::nonNull).filter(predicate).findFirst().map(arg -> arg.substring(arg.indexOf(SEPARATOR_KEY_VALUE) + 1)).map(String::trim).filter(value -> !value.isEmpty());
    }

    private SharedClassLoader createSharedClassLoader(String frameworkFolder, List<String> sharedFolders, List<String> parentClassLoaderNames) {
        List<File> sharedDirectories = this.getSharedDirectories(frameworkFolder, sharedFolders);
        ClassLoader parentLoader = ClassLoaderUtils.lookupClassLoader(classLoader -> parentClassLoaderNames.contains(classLoader.getClass().getSimpleName()));
        return this.classLoaderSupplier.getSharedClassLoader(sharedDirectories, parentLoader);
    }

    private List<File> getSharedDirectories(String frameworkFolder, List<String> sharedFolders) {
        File shared = FileUtils.canonicalize(frameworkFolder).toPath().resolve(SHARED_PARENT_FOLDER).toFile();
        List<File> sharedDirectories = sharedFolders.stream().map(FileUtils::canonicalize).collect(Collectors.toList());
        sharedDirectories.add(shared);
        return sharedDirectories;
    }

    private FrameworkClassLoader createFrameworkClassLoader(String frameworkFolder, ClassLoader sharedClassLoader) {
        Path frameworkParent = FileUtils.canonicalize(frameworkFolder).toPath().resolve(FRAMEWORK_PARENT_FOLDER);
        List<File> frameworkDirectories = FRAMEWORK_FOLDERS.stream().map(frameworkParent::resolve).map(Path::toFile).collect(Collectors.toList());
        return this.classLoaderSupplier.getFrameworkClassLoader(frameworkDirectories, sharedClassLoader);
    }

    private Optional<Class<?>> getEntryClass() {
        try {
            return Optional.of(this.frameworkClassLoader.loadClass(RUNTIME_CLASS_NAME));
        }
        catch (ClassNotFoundException e) {
            throw new FitFrameworkStartupException(String.format(Locale.ROOT, "Fail to start fit runtime: no entry class. [entryClass=%s]", RUNTIME_CLASS_NAME), e);
        }
    }

    private Optional<Method> getEntryMethod(Class<?> runtimeClass) {
        try {
            return Optional.of(runtimeClass.getDeclaredMethod(MAIN, Long.TYPE, String[].class));
        }
        catch (NoSuchMethodException e) {
            throw new FitFrameworkStartupException(String.format(Locale.ROOT, "Fail to start fit runtime: no entry method. [entryMethod=%s#%s(long startTime, String[] args)]", RUNTIME_CLASS_NAME, MAIN), e);
        }
    }

    private boolean isStatic(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return true;
        }
        throw new FitFrameworkStartupException(String.format(Locale.ROOT, "Fail to start fit runtime: the entry method is not a valid Java main method. [methodModifiers=%s]", Modifier.toString(method.getModifiers())));
    }

    private Object invoke(Method method, long startTime, String[] args) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.frameworkClassLoader);
            Object object = method.invoke(null, startTime, args);
            return object;
        }
        catch (IllegalAccessException e) {
            throw new FitFrameworkStartupException(String.format(Locale.ROOT, "Fail to start fit runtime: no access to invoke entry method. [methodModifiers=%s]", Modifier.toString(method.getModifiers())), e);
        }
        catch (InvocationTargetException e) {
            throw new FitFrameworkStartupException(String.format(Locale.ROOT, "Fail to start fit runtime: exception occurs. Below is error summary, for details, see log please. [exception=%s:%s]", this.getExceptionName(e.getCause()), this.getExceptionReason(e.getCause())), e.getCause());
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private String getExceptionReason(Throwable throwable) {
        return Optional.ofNullable(throwable).map(Throwable::getMessage).orElse("No exception");
    }

    private String getExceptionName(Throwable throwable) {
        return Optional.ofNullable(throwable).map(Object::getClass).map(Class::getSimpleName).orElse("Unknown");
    }
}

