/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.serialization.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.huawei.fitframework.annotation.Alias;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.broker.serialization.MessageSerializer;
import com.huawei.fitframework.broker.serialization.jackson.util.JsonUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.exception.DegradableException;
import com.huawei.fitframework.exception.FitException;
import com.huawei.fitframework.exception.SystemError;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="serializer:1")
@Fitable
public class JacksonMessageSerializer
implements MessageSerializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JacksonMessageSerializer.class);
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final Charset charset;

    public JacksonMessageSerializer(@Value(value="${serialization.json.charset}") String charsetName) {
        this.charset = JacksonMessageSerializer.charset(charsetName);
    }

    private static Charset charset(String charsetName) {
        if (charsetName == null) {
            return DEFAULT_CHARSET;
        }
        try {
            return Charset.forName(charsetName);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException ex) {
            log.warn("Use default charset because the required one is unsupported. [required={}, default={}]", (Object)charsetName, (Object)DEFAULT_CHARSET.name());
            return DEFAULT_CHARSET;
        }
    }

    public byte[] serializeRequest(Type[] argumentTypes, Object[] arguments) {
        ArrayNode array = this.mapper.createArrayNode();
        for (Object argument : arguments) {
            array.addPOJO(argument);
        }
        try {
            String json = this.mapper.writeValueAsString((Object)array);
            return json.getBytes(this.charset);
        }
        catch (JsonProcessingException ex) {
            throw new DegradableException(SystemError.JSON_SERIALIZATION_PROCESSING_ERROR.getCode(), SystemError.JSON_SERIALIZATION_PROCESSING_ERROR.getMessage(), "Fail to write input arguments as a JSON.", (Throwable)ex);
        }
    }

    public Object[] deserializeRequest(Type[] argumentClasses, byte[] data) {
        String json = new String(data, this.charset);
        ArrayNode array = JsonUtils.parseNode(this.mapper, ArrayNode.class, json);
        if (array.size() != argumentClasses.length) {
            throw new DegradableException(SystemError.SERIALIZATION_FORMAT_ERROR.getCode(), SystemError.SERIALIZATION_FORMAT_ERROR.getMessage(), StringUtils.format((String)"Total {0} arguments supplied but {1} required.", (Object[])new Object[]{array.size(), argumentClasses.length}));
        }
        Object[] arguments = new Object[argumentClasses.length];
        for (int i = 0; i < argumentClasses.length; ++i) {
            arguments[i] = JsonUtils.deserializeNode(this.mapper, array.get(i), argumentClasses[i]);
        }
        return arguments;
    }

    public <T> byte[] serializeResponse(Type dataType, T data) {
        String json;
        try {
            json = this.mapper.writeValueAsString(data);
        }
        catch (JsonProcessingException ex) {
            throw new FitException(SystemError.JSON_SERIALIZATION_PROCESSING_ERROR.getCode(), SystemError.JSON_SERIALIZATION_PROCESSING_ERROR.getMessage(), "Fail to write input arguments as a JSON.", (Throwable)ex);
        }
        return json.getBytes(this.charset);
    }

    public <T> T deserializeResponse(Type dataType, byte[] data) {
        if (data == null || data.length <= 0) {
            return null;
        }
        if (this.isVoid(dataType)) {
            return null;
        }
        String json = new String(data, this.charset);
        try {
            return JsonUtils.deserializeNode(this.mapper, this.mapper.readTree(json), dataType);
        }
        catch (JsonProcessingException e) {
            throw new FitException(SystemError.JSON_DESERIALIZATION_PROCESSING_ERROR.getCode(), SystemError.JSON_DESERIALIZATION_PROCESSING_ERROR.getMessage(), StringUtils.format((String)"dataType={0}", (Object[])new Object[]{dataType.getTypeName()}), (Throwable)e);
        }
    }

    private boolean isVoid(Type dataClass) {
        return dataClass == Void.class || dataClass == Void.TYPE;
    }

    public boolean isSupportedSerialization(String genericableId) {
        return true;
    }
}

