/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.serialization.jackson.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.serialization.SerializationException;
import java.lang.reflect.Type;

public class JsonUtils {
    private JsonUtils() {
    }

    public static <T extends JsonNode> T parseNode(ObjectMapper mapper, Class<T> nodeClass, String json) {
        try {
            JsonNode node = mapper.readTree(json);
            if (nodeClass.isInstance(node)) {
                return (T)node;
            }
            throw new SerializationException(StringUtils.format((String)"The input arguments is not an instance of {0}.", (Object[])new Object[]{nodeClass.getName()}));
        }
        catch (JsonProcessingException ex) {
            throw new SerializationException("Fail to read JSON array from input bytes.", (Throwable)ex);
        }
    }

    public static <T> T deserializeNode(ObjectMapper mapper, JsonNode node, Type objectType) {
        return (T)mapper.convertValue((Object)node, mapper.constructType(objectType));
    }
}

