/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.number.parse;

import org.python.icu.impl.StaticUnicodeSets;
import org.python.icu.impl.StringSegment;
import org.python.icu.impl.number.DecimalQuantity_DualStorageBCD;
import org.python.icu.impl.number.Grouper;
import org.python.icu.impl.number.parse.DecimalMatcher;
import org.python.icu.impl.number.parse.NumberParseMatcher;
import org.python.icu.impl.number.parse.ParsedNumber;
import org.python.icu.impl.number.parse.ParsingUtils;
import org.python.icu.text.DecimalFormatSymbols;
import org.python.icu.text.UnicodeSet;

public class ScientificMatcher
implements NumberParseMatcher {
    private final String exponentSeparatorString;
    private final DecimalMatcher exponentMatcher;
    private final String customMinusSign;
    private final String customPlusSign;

    public static ScientificMatcher getInstance(DecimalFormatSymbols symbols2, Grouper grouper) {
        return new ScientificMatcher(symbols2, grouper);
    }

    private ScientificMatcher(DecimalFormatSymbols symbols2, Grouper grouper) {
        this.exponentSeparatorString = symbols2.getExponentSeparator();
        this.exponentMatcher = DecimalMatcher.getInstance(symbols2, grouper, 48);
        String minusSign = symbols2.getMinusSignString();
        this.customMinusSign = ParsingUtils.safeContains(ScientificMatcher.minusSignSet(), minusSign) ? null : minusSign;
        String plusSign = symbols2.getPlusSignString();
        this.customPlusSign = ParsingUtils.safeContains(ScientificMatcher.plusSignSet(), plusSign) ? null : plusSign;
    }

    private static UnicodeSet minusSignSet() {
        return StaticUnicodeSets.get(StaticUnicodeSets.Key.MINUS_SIGN);
    }

    private static UnicodeSet plusSignSet() {
        return StaticUnicodeSets.get(StaticUnicodeSets.Key.PLUS_SIGN);
    }

    @Override
    public boolean match(StringSegment segment, ParsedNumber result2) {
        if (!result2.seenNumber()) {
            return false;
        }
        int overlap1 = segment.getCommonPrefixLength(this.exponentSeparatorString);
        if (overlap1 == this.exponentSeparatorString.length()) {
            boolean wasNull;
            int overlap2;
            if (segment.length() == overlap1) {
                return true;
            }
            segment.adjustOffset(overlap1);
            int exponentSign = 1;
            if (segment.startsWith(ScientificMatcher.minusSignSet())) {
                exponentSign = -1;
                segment.adjustOffsetByCodePoint();
            } else if (segment.startsWith(ScientificMatcher.plusSignSet())) {
                segment.adjustOffsetByCodePoint();
            } else if (segment.startsWith(this.customMinusSign)) {
                overlap2 = segment.getCommonPrefixLength(this.customMinusSign);
                if (overlap2 != this.customMinusSign.length()) {
                    segment.adjustOffset(-overlap1);
                    return true;
                }
                exponentSign = -1;
                segment.adjustOffset(overlap2);
            } else if (segment.startsWith(this.customPlusSign)) {
                overlap2 = segment.getCommonPrefixLength(this.customPlusSign);
                if (overlap2 != this.customPlusSign.length()) {
                    segment.adjustOffset(-overlap1);
                    return true;
                }
                segment.adjustOffset(overlap2);
            }
            boolean bl = wasNull = result2.quantity == null;
            if (wasNull) {
                result2.quantity = new DecimalQuantity_DualStorageBCD();
            }
            int digitsOffset = segment.getOffset();
            boolean digitsReturnValue = this.exponentMatcher.match(segment, result2, exponentSign);
            if (wasNull) {
                result2.quantity = null;
            }
            if (segment.getOffset() != digitsOffset) {
                result2.flags |= 8;
            } else {
                segment.adjustOffset(-overlap1);
            }
            return digitsReturnValue;
        }
        return overlap1 == segment.length();
    }

    @Override
    public boolean smokeTest(StringSegment segment) {
        return segment.startsWith(this.exponentSeparatorString);
    }

    @Override
    public void postProcess(ParsedNumber result2) {
    }

    public String toString() {
        return "<ScientificMatcher " + this.exponentSeparatorString + ">";
    }
}

