/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.registry;

import com.huawei.fit.hakuna.kernel.registry.server.QueryFitablesAddresses;
import com.huawei.fit.hakuna.kernel.registry.server.RegisterFitables;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.Application;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.ApplicationInstance;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.FitableInstance;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.FitableMeta;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.Worker;
import com.huawei.fit.hakuna.kernel.shared.entity.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.core.common.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class RegistryServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegistryServer.class);
    private static final String REGISTER_INSTANCES_KEY_FORMAT = "{0},{1}";
    private final Map<String, FitableInstance> registeredInstances = new HashMap<String, FitableInstance>();

    @com.huawei.fitframework.annotation.Fitable(generic=QueryFitablesAddresses.class, id="cbe6769b9dc040988d3c83b81323b106")
    public List<FitableInstance> queryFitablesAddresses(List<Fitable> fitables, String workerId) {
        return fitables.stream().map(this::getRegisterInstancesKey).distinct().map(this.registeredInstances::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private boolean isExistSameWorkId(ApplicationInstance applicationInstance, String workId) {
        return applicationInstance.getWorkers().stream().map(Worker::getId).anyMatch(existWorkId -> Objects.equals(workId, existWorkId));
    }

    private String getRegisterInstancesKey(Fitable fitable) {
        return StringUtils.format((String)REGISTER_INSTANCES_KEY_FORMAT, (Object[])new Object[]{fitable.getFitableId(), fitable.getFitableVersion()});
    }

    @com.huawei.fitframework.annotation.Fitable(generic=RegisterFitables.class, id="9457fb6df4b34438a3f0b8cf24805f90")
    public void registerFitables(List<FitableMeta> fitableMetas, Worker worker, Application application) {
        fitableMetas.forEach(fitableMeta -> this.registerFitable((FitableMeta)fitableMeta, worker, application));
    }

    private void registerFitable(FitableMeta fitableMeta, Worker worker, Application application) {
        log.info("Start to register fitable. [fitableId={}, workId={}, applicationName={}]", new Object[]{fitableMeta.getFitable().getFitableId(), worker.getId(), application.getName()});
        String registerInstancesKey = this.getRegisterInstancesKey(fitableMeta.getFitable());
        FitableInstance instance = this.registeredInstances.containsKey(registerInstancesKey) ? this.updateInstance(this.registeredInstances.get(registerInstancesKey), worker, application, fitableMeta.getFormats()) : this.buildFitableInstance(fitableMeta, worker, application);
        this.registeredInstances.put(registerInstancesKey, instance);
    }

    private FitableInstance buildFitableInstance(FitableMeta fitableMeta, Worker worker, Application application) {
        return FitableInstance.builder().fitable(this.buildFitable(fitableMeta)).applicationInstances(Collections.singletonList(this.buildApplicationInstance(worker, application, fitableMeta.getFormats()))).build();
    }

    private FitableInstance updateInstance(FitableInstance fitableInstance, Worker worker, Application application, List<Integer> formats) {
        List applicationInstances = fitableInstance.getApplicationInstances();
        Optional<ApplicationInstance> existApplicationInstanceOptional = applicationInstances.stream().filter(applicationInstance -> this.isExistSameApplicationInstance((ApplicationInstance)applicationInstance, application)).findFirst();
        if (!existApplicationInstanceOptional.isPresent()) {
            fitableInstance.getApplicationInstances().add(this.buildApplicationInstance(worker, application, formats));
            return fitableInstance;
        }
        ApplicationInstance applicationInstance2 = existApplicationInstanceOptional.get();
        if (this.isExistSameWorkId(applicationInstance2, worker.getId())) {
            return fitableInstance;
        }
        applicationInstance2.getWorkers().add(this.buildWorker(worker));
        return fitableInstance;
    }

    private ApplicationInstance buildApplicationInstance(Worker worker, Application application, List<Integer> formats) {
        return ApplicationInstance.builder().workers(Collections.singletonList(this.buildWorker(worker))).application(application).formats(formats).build();
    }

    private Worker buildWorker(Worker worker) {
        return Worker.builder().addresses(worker.getAddresses()).id(worker.getId()).expire(worker.getExpire()).environment(worker.getEnvironment()).build();
    }

    private boolean isExistSameApplicationInstance(ApplicationInstance applicationInstance, Application application) {
        return Objects.equals(applicationInstance.getApplication().getName(), application.getName()) && Objects.equals(applicationInstance.getApplication().getNameVersion(), application.getNameVersion());
    }

    private Fitable buildFitable(FitableMeta fitableMeta) {
        return Fitable.builder().genericableId(fitableMeta.getFitable().getGenericableId()).genericableVersion(fitableMeta.getFitable().getGenericableVersion()).fitableId(fitableMeta.getFitable().getFitableId()).fitableVersion(fitableMeta.getFitable().getFitableVersion()).build();
    }
}

