/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.impl.ModificationBatchConfiguration;
import org.camunda.bpm.engine.impl.ModificationBuilderImpl;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.DeploymentMapping;
import org.camunda.bpm.engine.impl.batch.DeploymentMappings;
import org.camunda.bpm.engine.impl.batch.builder.BatchBuilder;
import org.camunda.bpm.engine.impl.cmd.AbstractModificationCmd;
import org.camunda.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class ProcessInstanceModificationBatchCmd
extends AbstractModificationCmd<Batch> {
    public ProcessInstanceModificationBatchCmd(ModificationBuilderImpl modificationBuilderImpl) {
        super(modificationBuilderImpl);
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        List<AbstractProcessInstanceModificationCommand> instructions = this.builder.getInstructions();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "Modification instructions cannot be empty", instructions);
        Collection<String> collectedInstanceIds = this.collectProcessInstanceIds();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "Process instance ids cannot be empty", "Process instance ids", collectedInstanceIds);
        EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "Process instance ids cannot be null", "Process instance ids", collectedInstanceIds);
        String processDefinitionId = this.builder.getProcessDefinitionId();
        ProcessDefinitionEntity processDefinition = this.getProcessDefinition(commandContext, processDefinitionId);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Process definition id cannot be null", (Object)processDefinition);
        String tenantId = processDefinition.getTenantId();
        String annotation = this.builder.getAnnotation();
        return new BatchBuilder(commandContext).type("instance-modification").config(this.getConfiguration(collectedInstanceIds, processDefinition.getDeploymentId())).tenantId(tenantId).permission(BatchPermissions.CREATE_BATCH_MODIFY_PROCESS_INSTANCES).operationLogHandler((ctx, instanceCount) -> this.writeUserOperationLog(ctx, processDefinition, instanceCount, true, annotation)).build();
    }

    public BatchConfiguration getConfiguration(Collection<String> instanceIds, String deploymentId) {
        return new ModificationBatchConfiguration(new ArrayList<String>(instanceIds), DeploymentMappings.of(new DeploymentMapping(deploymentId, instanceIds.size())), this.builder.getProcessDefinitionId(), this.builder.getInstructions(), this.builder.isSkipCustomListeners(), this.builder.isSkipIoMappings());
    }
}

