/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.conf.config.support;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.configcenter.ConfigCenterClient;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.ExceptionUtils;
import com.huawei.fitframework.core.common.util.LockUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.matata.conf.client.Download;
import com.huawei.matata.conf.subscription.client.Append;
import com.huawei.matata.notification.client.Subscribe;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Fitable
public class DefaultConfigCenterClient
implements ConfigCenterClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultConfigCenterClient.class);
    public static final String GENERICABLES_SUBSCRIPTION_GROUP_FORMAT = "{0}:genericables";
    private static final int CONCURRENCY = 10;
    private static final String MQ_CLIENT_CONSUMER_FITABLE_ID = "109a2bcd568e4b2e9eba65a73a4fe69d";
    private final String workerId;
    private final Download downloader;
    private final Append appender;
    private final Subscribe subscriber;
    private final Lock lock = LockUtils.newReentrantLock();
    private final Set<String> subscribedGroups = new HashSet<String>();

    public DefaultConfigCenterClient(@Value(value="${server.id}") String workerId, Download downloader, Subscribe subscriber, Append appender) {
        this.workerId = Validation.notBlank((String)workerId, (String)"No worker id.", (Object[])new Object[0]);
        log.info("DefaultConfigCenterClient received worker id is {}.", (Object)this.workerId);
        this.downloader = downloader;
        this.appender = appender;
        this.subscriber = subscriber;
    }

    public void subscribe(String subscriptionGroup, String configPath) {
        Validation.notBlank((String)configPath, (String)"No config path to subscribe.", (Object[])new Object[0]);
        this.subscribe(subscriptionGroup, Collections.singletonList(configPath));
    }

    public void subscribe(String subscriptionGroup, List<String> configPaths) {
        Validation.notBlank((String)subscriptionGroup, (String)"No subscription group to subscribe.", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(configPaths)) {
            log.info("Skip to subscribe configs: no config path. [subscriptionGroup={}]", (Object)subscriptionGroup);
            return;
        }
        log.info("Prepare to subscribe configuration. [subscriptionGroup={}, configPaths={}]", (Object)subscriptionGroup, configPaths);
        this.subscribe0(subscriptionGroup, configPaths);
        log.info("Subscribe configuration successfully. [subscriptionGroup={}, configPaths={}]", (Object)subscriptionGroup, configPaths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subscribe0(String subscriptionGroup, List<String> configPaths) {
        try {
            log.debug("Prepare to append config paths to subscription group. [subscriptionGroup={}, configPaths={}]", (Object)subscriptionGroup, configPaths);
            this.appender.process(subscriptionGroup, configPaths);
            log.debug("Append config paths to subscription group successfully. [subscriptionGroup={}, configPaths={}]", (Object)subscriptionGroup, configPaths);
            boolean isSubscribed = this.subscribedGroups.contains(subscriptionGroup);
            if (isSubscribed) {
                log.info("Skip to subscribe configs: it has been subscribed. [subscriptionGroup={}, configPaths={}]", (Object)subscriptionGroup, configPaths);
                return;
            }
            this.lock.lock();
            try {
                isSubscribed = this.subscribedGroups.contains(subscriptionGroup);
                if (isSubscribed) {
                    log.info("Skip to subscribe configs: it has been subscribed. [subscriptionGroup={}, configPaths={}]", (Object)subscriptionGroup, configPaths);
                    return;
                }
                log.debug("Prepare to subscribe. [subscriptionGroup={}]", (Object)subscriptionGroup);
                this.subscriber.process(this.workerId, subscriptionGroup, MQ_CLIENT_CONSUMER_FITABLE_ID);
                log.debug("Subscribe successfully. [subscriptionGroup={}]", (Object)subscriptionGroup);
                this.subscribedGroups.add(subscriptionGroup);
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (Exception e) {
            log.warn("Fail to subscribe configuration. [subscriptionGroup={}, configPaths={}]", (Object)subscriptionGroup, configPaths);
            log.debug("Fail to subscribe configuration.", (Throwable)e);
        }
    }

    public Map<String, String> download(String configPath) {
        return this.downloadConfig(configPath);
    }

    public void download(String configPath, BiConsumer<String, Map<String, String>> consumer) {
        if (StringUtils.isBlank((String)configPath)) {
            return;
        }
        this.downloadAndApplyConfig(configPath, consumer);
    }

    public void download(List<String> configPaths, BiConsumer<String, Map<String, String>> consumer) {
        if (CollectionUtils.isEmpty(configPaths)) {
            return;
        }
        Flux.fromIterable(configPaths).filter(StringUtils::isNotBlank).flatMap(path -> this.asyncDownloadAndApplyConfig((String)path, consumer), 10).blockLast();
    }

    private Mono<Object> asyncDownloadAndApplyConfig(String configPath, BiConsumer<String, Map<String, String>> consumer) {
        return Mono.fromRunnable(() -> this.downloadAndApplyConfig(configPath, consumer)).subscribeOn(Schedulers.parallel());
    }

    private void downloadAndApplyConfig(String configPath, BiConsumer<String, Map<String, String>> consumer) {
        Map<String, String> values = this.downloadConfig(configPath);
        consumer.accept(configPath, values);
    }

    private Map<String, String> downloadConfig(String configPath) {
        try {
            log.info("Prepare to download configuration. [configPath={}]", (Object)configPath);
            Map configsMap = this.downloader.process(configPath);
            log.info("Download configuration successfully. [configPath={}]", (Object)configPath);
            return configsMap;
        }
        catch (Exception e) {
            log.warn("Fail to download configuration, change result to empty map. [configPath={}]", (Object)configPath);
            log.debug(ExceptionUtils.getReason((Throwable)e), (Throwable)e);
            return Collections.emptyMap();
        }
    }
}

