/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.conf.config.support;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.Order;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.configcenter.ConfigCenterClient;
import com.huawei.fitframework.configcenter.ConfigCenterListener;
import com.huawei.fitframework.configcenter.ConfigCenterObserver;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.runtime.ApplicationStartedObserver;
import com.huawei.fitframework.runtime.PluginBrief;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
@Order(value=-1000)
public class DefaultConfigCenterListener
implements ConfigCenterListener,
ApplicationStartedObserver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultConfigCenterListener.class);
    private static final char CONFIG_PATH_SEPARATOR = '\n';
    private final List<ConfigCenterObserver> observers = new ArrayList<ConfigCenterObserver>();
    private final ConfigCenterClient configCenterClient;
    private final Map<String, BiConsumer<String, Map<String, String>>> consumers = new HashMap<String, BiConsumer<String, Map<String, String>>>();
    private final String appName;

    public DefaultConfigCenterListener(ConfigCenterClient configCenterClient, @Value(value="${app.name}") String appName) {
        this.configCenterClient = configCenterClient;
        this.appName = appName;
    }

    public void addConfigCenterObserver(ConfigCenterObserver observer) {
        Optional.ofNullable(observer).ifPresent(this.observers::add);
    }

    public void addSubscriptionGroupConsumer(String subscriptionGroup, BiConsumer<String, Map<String, String>> consumer) {
        Validation.notBlank((String)subscriptionGroup, (String)"No subscription group.", (Object[])new Object[0]);
        Validation.notNull(consumer, (String)"The consumer of subscription group cannot be empty. [subscriptionGroup={0}]", (Object[])new Object[]{subscriptionGroup});
        this.consumers.put(subscriptionGroup, consumer);
    }

    public void onConfigPathsChanged(String subscriptionGroup, byte[] configPaths) {
        if (StringUtils.isBlank((String)subscriptionGroup)) {
            log.warn("No subscription group on config paths changed.");
            return;
        }
        if (configPaths == null) {
            log.warn("No config paths on config paths changed.");
            return;
        }
        List configPathList = StringUtils.splitToList((String)new String(configPaths, StandardCharsets.UTF_8), (char)'\n');
        log.info("Received config paths changed. [subscriptionGroup={}, configPaths={}]", (Object)subscriptionGroup, (Object)configPathList);
        BiConsumer<String, Map> consumer = this.consumers.getOrDefault(subscriptionGroup, this::onPropertiesChanged);
        this.configCenterClient.download(configPathList, consumer);
    }

    public void onPropertiesChanged(String configPath, Map<String, String> properties) {
        this.observers.stream().filter(observer -> observer.acceptable(configPath)).forEach(observer -> observer.accept(configPath, properties));
    }

    public void onApplicationStarted(List<PluginBrief> plugins) {
        this.subscribeAndDownloadGenericConfigs();
    }

    private void subscribeAndDownloadGenericConfigs() {
        List configPathList = this.observers.stream().flatMap(observer -> observer.getConfigPaths().stream()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(configPathList)) {
            return;
        }
        this.configCenterClient.subscribe(StringUtils.format((String)"{0}:genericables", (Object[])new Object[]{this.appName}), configPathList);
        this.configCenterClient.download(configPathList, this::onPropertiesChanged);
    }
}

