/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.conf.config.support;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.conf.config.ConfigService;
import com.huawei.fitframework.conf.config.support.AbstractConfigObserver;
import com.huawei.fitframework.configcenter.ConfigCenterClient;
import com.huawei.fitframework.configcenter.ConfigCenterListener;
import com.huawei.fitframework.core.common.util.MapUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class DefaultConfigCenterObserver
extends AbstractConfigObserver
implements ConfigService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultConfigCenterObserver.class);
    private final Map<String, ConfigKeyMapping> pathCache = new ConcurrentHashMap<String, ConfigKeyMapping>();
    private final Map<String, ObserverMapping> observerCache = new HashMap<String, ObserverMapping>();
    private final ConfigCenterClient configCenterClient;

    public DefaultConfigCenterObserver(ConfigCenterListener configSubject, ConfigCenterClient configCenterClient) {
        super(configSubject);
        this.configCenterClient = configCenterClient;
    }

    public List<String> getConfigPaths() {
        return Collections.unmodifiableList(new ArrayList<String>(this.pathCache.keySet()));
    }

    public boolean acceptable(String configPath) {
        return StringUtils.isNotBlank((String)configPath);
    }

    public void accept(String configPath, Map<String, String> properties) {
        if (StringUtils.isBlank((String)configPath) || MapUtils.isEmpty(properties)) {
            return;
        }
        this.pathCache.compute(configPath, (key, mapping) -> this.merge((ConfigKeyMapping)mapping, properties));
        this.notifyObservers(configPath, properties);
    }

    @Override
    public Object getConfig(String path, String key) {
        if (StringUtils.isBlank((String)path) || StringUtils.isBlank((String)key)) {
            return null;
        }
        ConfigKeyMapping keyMapping = this.pathCache.get(path);
        return Optional.ofNullable(keyMapping).map(mapping -> mapping.get(key)).orElseGet(() -> this.load(path, key));
    }

    @Override
    public void addObserver(String configPath, String configKey, Consumer<Object> observer) {
        if (StringUtils.isBlank((String)configPath) || StringUtils.isBlank((String)configKey) || observer == null) {
            return;
        }
        ObserverMapping observerMapping = this.observerCache.computeIfAbsent(configPath, key -> new ObserverMapping());
        observerMapping.addObserver(configKey, observer);
    }

    private Object load(String configPath, String configKey) {
        Map configsMap = this.configCenterClient.download(configPath);
        if (MapUtils.isEmpty((Map)configsMap)) {
            return null;
        }
        this.pathCache.compute(configPath, (key, mapping) -> this.merge((ConfigKeyMapping)mapping, configsMap));
        return this.pathCache.get(configPath).get(configKey);
    }

    private void notifyObservers(String configPath, Map<String, String> configsMap) {
        ObserverMapping mapping = this.observerCache.get(configPath);
        if (mapping == null) {
            return;
        }
        configsMap.forEach((key, value) -> mapping.getObservers((String)key).forEach(observer -> observer.accept(value)));
    }

    private ConfigKeyMapping merge(ConfigKeyMapping configKeyMapping, Map<String, String> configsMap) {
        ConfigKeyMapping mapping = Optional.ofNullable(configKeyMapping).orElseGet(ConfigKeyMapping::new);
        configsMap.forEach(mapping::putMapping);
        return mapping;
    }

    private static class ObserverMapping {
        private final Map<String, List<Consumer<Object>>> configKeyObserverListMap = new HashMap<String, List<Consumer<Object>>>();

        public void addObserver(String configKey, Consumer<Object> observer) {
            List observerList = this.configKeyObserverListMap.computeIfAbsent(configKey, key -> new ArrayList());
            observerList.add(observer);
        }

        public List<Consumer<Object>> getObservers(String configKey) {
            return Optional.ofNullable(this.configKeyObserverListMap.get(configKey)).orElseGet(ArrayList::new);
        }
    }

    static class ConfigKeyMapping {
        private final Map<String, Object> configKeyValueMap = new HashMap<String, Object>();

        public void putMapping(String key, Object value) {
            this.configKeyValueMap.put(key, value);
        }

        public Object get(String key) {
            return this.configKeyValueMap.get(key);
        }
    }
}

