/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.conf.config.support;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.conf.BrokerConfigurationConfigurator;
import com.huawei.fitframework.broker.conf.ConfigurationLoader;
import com.huawei.fitframework.broker.conf.ConfigureMode;
import com.huawei.fitframework.broker.conf.GenericableConfiguration;
import com.huawei.fitframework.conf.config.support.AbstractConfigObserver;
import com.huawei.fitframework.configcenter.ConfigCenterListener;
import com.huawei.fitframework.core.common.util.MapUtils;
import com.huawei.fitframework.core.common.util.PropertiesUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class GenericableConfigObserver
extends AbstractConfigObserver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericableConfigObserver.class);
    public static final String GENERICABLES_PREFIX = "fit.public.genericables.";
    public static final Pattern GENERICABLE_CONFIG_PATTERN = Pattern.compile("fit\\.public\\.genericables\\.([0-9a-fA-F]{32})");
    private static final int GENERICABLE_ID_INDEX = 1;
    private final ProxyFactory factory;
    private final ConfigurationLoader configurationLoader;

    public GenericableConfigObserver(ProxyFactory proxyFactory, ConfigurationLoader configurationLoader, ConfigCenterListener configSubject) {
        super(configSubject);
        this.factory = proxyFactory;
        this.configurationLoader = configurationLoader;
    }

    public List<String> getConfigPaths() {
        return this.factory.listGenericableIds().stream().filter(genericableId -> !this.isGenericableReadOnly((String)genericableId)).map(genericableId -> GENERICABLES_PREFIX + genericableId).collect(Collectors.toList());
    }

    public boolean acceptable(String configPath) {
        return StringUtils.isNotBlank((String)configPath) && this.isGenericablePath(configPath);
    }

    private boolean isGenericablePath(String configPath) {
        Matcher matcher = GENERICABLE_CONFIG_PATTERN.matcher(configPath);
        return matcher.matches();
    }

    public void accept(String configPath, Map<String, String> properties) {
        String genericableId = this.getGenericableId(configPath);
        if (StringUtils.isBlank((String)genericableId) || MapUtils.isEmpty(properties)) {
            log.warn("Received genericable configuration, but no values. [genericableId={}]", (Object)genericableId);
            return;
        }
        if (this.isGenericableReadOnly(genericableId)) {
            log.warn("Received genericable configuration, but it is read only, skip to change values. [genericableId={}, values={}]", (Object)genericableId, properties);
            return;
        }
        log.info("Received genericable configuration, prepare to change it. [genericableId={}, values={}]", (Object)genericableId, properties);
        this.configurationLoader.configure(BrokerConfigurationConfigurator.genericable((String)genericableId, this.convert(properties)), ConfigureMode.REPLACE);
    }

    private boolean isGenericableReadOnly(String genericableId) {
        return this.configurationLoader.load().genericable(genericableId).map(GenericableConfiguration::tags).map(tags -> tags.stream().anyMatch(tag -> Objects.equals(tag, "readOnly"))).orElse(false);
    }

    private String getGenericableId(String configPath) {
        Validation.notBlank((String)configPath, (String)"No config path.", (Object[])new Object[0]);
        Matcher matcher = GENERICABLE_CONFIG_PATTERN.matcher(configPath);
        Validation.isTrue((boolean)matcher.matches(), (String)"Config path is not match genericable config. [path={0}]", (Object[])new Object[]{configPath});
        return matcher.group(1);
    }

    private Map<String, Object> convert(Map<String, String> input) {
        Properties properties = new Properties();
        input.forEach(properties::setProperty);
        return PropertiesUtils.mapFrom((Properties)properties);
    }
}

