/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.conf.ioc;

import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.broker.client.BrokerClient;
import com.huawei.fitframework.conf.Config;
import com.huawei.fitframework.conf.config.ConfigService;
import com.huawei.fitframework.conf.exception.ConfigurationInjectionException;
import com.huawei.fitframework.core.common.parameterization.ParameterizedString;
import com.huawei.fitframework.core.common.parameterization.ParameterizedStringResolver;
import com.huawei.fitframework.core.common.parameterization.ResolvedParameter;
import com.huawei.fitframework.core.common.parameterization.support.DefaultParameterizedStringResolver;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.OptionalUtils;
import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.core.common.util.ValueConverter;
import com.huawei.fitframework.ioc.ComponentBrief;
import com.huawei.fitframework.ioc.DependencyResolver;
import com.huawei.fitframework.ioc.DependencyResolvingResult;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationDependencyResolver
implements DependencyResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurationDependencyResolver.class);
    private static final ParameterizedStringResolver RESOLVER = new DefaultParameterizedStringResolver("${", "}", '/');
    private final Config config;
    private final BrokerClient brokerClient;

    public ConfigurationDependencyResolver(Config config, BrokerClient brokerClient) {
        this.config = (Config)Validation.notNull((Object)config, (String)"The configuration to resolve dependencies cannot be null.", (Object[])new Object[0]);
        this.brokerClient = brokerClient;
    }

    public boolean isPreferredConstructor(Constructor<?> constructor) {
        return false;
    }

    public boolean isResolvable(ComponentBrief brief, Parameter parameter) {
        return ConfigurationDependencyResolver.isAnnotationDeclared(parameter);
    }

    public boolean isResolvable(ComponentBrief brief, Field field) {
        return ConfigurationDependencyResolver.isAnnotationDeclared(field);
    }

    private static boolean isAnnotationDeclared(AnnotatedElement element) {
        return element.isAnnotationPresent(Value.class);
    }

    public DependencyResolvingResult resolve(ComponentBrief brief, Parameter parameter) {
        return this.getConfig(brief, parameter, parameter.getType(), new ParameterConfigResolver(this.config));
    }

    public DependencyResolvingResult resolve(ComponentBrief brief, Object bean, Field field) {
        return this.getConfig(brief, field, field.getType(), new FieldConfigResolver(bean, this.config, (ConfigService)this.brokerClient.getProxyByDefault(ConfigService.class)));
    }

    private DependencyResolvingResult getConfig(ComponentBrief brief, AnnotatedElement element, Class<?> resultClass, ConfigResolver configResolver) {
        Value annotation = element.getAnnotation(Value.class);
        if (annotation == null) {
            return DependencyResolvingResult.failure();
        }
        ParameterizedString resolved = RESOLVER.resolve(annotation.value());
        Map<String, Object> parameters = configResolver.resolve(brief, element, resolved.getParameters());
        if (resolved.getParameters().size() != 1) {
            throw new ConfigurationInjectionException(StringUtils.format((String)"Not support more than 1 variable in @Value annotation. [value={0}]", (Object[])new Object[]{annotation.value()}));
        }
        ResolvedParameter parameter = (ResolvedParameter)resolved.getParameters().get(0);
        if (parameter.getPosition() != 0) {
            throw new ConfigurationInjectionException(StringUtils.format((String)"Not support extra info in @Value annotation. [value={0}]", (Object[])new Object[]{annotation.value()}));
        }
        Object actualValue = parameters.get(parameter.getName());
        if (actualValue == null) {
            return DependencyResolvingResult.create(null);
        }
        if (resultClass.isAssignableFrom(actualValue.getClass())) {
            return DependencyResolvingResult.create((Object)actualValue);
        }
        Object value = ValueConverter.convert((String)resolved.format(parameters), resultClass);
        return DependencyResolvingResult.create((Object)value);
    }

    private static class FieldConfigResolver
    implements ConfigResolver {
        private static final String DEFAULT_CONFIG_PATH_PREFIX = "/fit/public/plugins/";
        private static final String PLUGIN_CLASS_LOADER = "com.huawei.fitframework.plugin.loader.PluginClassLoader";
        private static final String GET_PLUGIN_NAME_METHOD_NAME = "getPluginName";
        private final Object bean;
        private final Config config;
        private final ConfigService configService;

        public FieldConfigResolver(Object bean, Config config, ConfigService configService) {
            this.bean = bean;
            this.config = config;
            this.configService = configService;
        }

        @Override
        public Map<String, Object> resolve(ComponentBrief brief, AnnotatedElement element, List<ResolvedParameter> parameters) {
            String realConfigPath;
            Value value = element.getAnnotation(Value.class);
            String configPath = value.configPath();
            Map parameterMap = parameters.stream().collect(HashMap::new, (map, parameter) -> map.put(parameter.getName(), this.get(brief.getComponentClass(), configPath, parameter.getName())), HashMap::putAll);
            String string = realConfigPath = StringUtils.isBlank((String)configPath) ? this.getDefaultConfigPath() : configPath;
            if (StringUtils.isNotBlank((String)realConfigPath)) {
                parameterMap.keySet().forEach(key -> this.addObserver(realConfigPath, (String)key, (Field)ObjectUtils.cast((Object)element)));
            }
            return parameterMap;
        }

        private void addObserver(String path, String key, Field field) {
            this.configService.addObserver(path, key, (Object value) -> ReflectionUtils.setField((Object)this.bean, (Field)field, (Object)value));
        }

        private Object get(Class<?> componentClass, String path, String key) {
            return OptionalUtils.get(() -> this.getByConfigPath(path, key)).orElse(() -> this.getByConfigPath(this.getDefaultConfigPath(), key)).orGetDefault(() -> this.config.get(componentClass, key));
        }

        private Optional<Object> getByConfigPath(String configPath, String key) {
            if (StringUtils.isBlank((String)configPath)) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.configService.getConfig(configPath, key));
        }

        private String getDefaultConfigPath() {
            ClassLoader classLoader = this.bean.getClass().getClassLoader();
            if (!PLUGIN_CLASS_LOADER.equals(classLoader.getClass().getName())) {
                return null;
            }
            Method method = ReflectionUtils.getDeclaredMethod(classLoader.getClass(), (String)GET_PLUGIN_NAME_METHOD_NAME, (Class[])new Class[0]);
            return DEFAULT_CONFIG_PATH_PREFIX + ReflectionUtils.invoke((Object)classLoader, (Method)method, (Object[])new Object[0]);
        }
    }

    private static class ParameterConfigResolver
    implements ConfigResolver {
        private final Config config;

        public ParameterConfigResolver(Config config) {
            this.config = config;
        }

        @Override
        public Map<String, Object> resolve(ComponentBrief brief, AnnotatedElement element, List<ResolvedParameter> parameters) {
            return parameters.stream().collect(HashMap::new, (map, parameter) -> map.put(parameter.getName(), this.config.get(brief.getComponentClass(), parameter.getName())), HashMap::putAll);
        }
    }

    private static interface ConfigResolver {
        public Map<String, Object> resolve(ComponentBrief var1, AnnotatedElement var2, List<ResolvedParameter> var3);
    }
}

