/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.conf.support;

import com.huawei.fitframework.conf.Config;
import com.huawei.fitframework.conf.ConfigUnit;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultConfig
implements Config {
    private final ConfigUnit highPriorityUnit;
    private final Map<ClassLoader, ConfigUnit> units;

    public DefaultConfig() {
        this(null);
    }

    public DefaultConfig(ConfigUnit highPriorityUnit) {
        this.highPriorityUnit = highPriorityUnit;
        this.units = new ConcurrentHashMap<ClassLoader, ConfigUnit>();
    }

    public void installUnit(ClassLoader loader, ConfigUnit unit) {
        Validation.notNull((Object)loader, (String)"The class loader associated with config unit to install cannot be null.", (Object[])new Object[0]);
        if (unit == null) {
            this.uninstallUnit(loader);
        } else {
            this.units.put(loader, unit);
        }
    }

    public void uninstallUnit(ClassLoader loader) {
        Validation.notNull((Object)loader, (String)"The class loader associated with config unit to uninstall cannot be null.", (Object[])new Object[0]);
        this.units.remove(loader);
    }

    public Object get(ClassLoader loader, String key) {
        Object value = DefaultConfig.get(this.highPriorityUnit, key);
        if (value == null) {
            value = DefaultConfig.get(this.units.get(loader), key);
        }
        if (value == null && loader != this.getClass().getClassLoader()) {
            value = DefaultConfig.get(this.units.get(this.getClass().getClassLoader()), key);
        }
        return value;
    }

    private static Object get(ConfigUnit unit, String key) {
        return ObjectUtils.mapIfNotNull((Object)unit, configUnit -> configUnit.get(key));
    }
}

