/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.ioc;

import com.huawei.fitframework.ioc.support.DefaultComponentBrief;
import java.util.Locale;
import java.util.Optional;

public interface ComponentBrief {
    public String getComponentName();

    public Class<?> getComponentClass();

    default public boolean isSingleton() {
        return "singleton".equalsIgnoreCase(this.getStereotype());
    }

    public String getStereotype();

    public static Builder builder() {
        return new DefaultComponentBrief.Builder();
    }

    public static Optional<String> toString(ComponentBrief brief) {
        return Optional.ofNullable(brief).map(componentBrief -> String.format(Locale.ROOT, "[componentName=%s, componentClass=%s, stereotype=%s]", componentBrief.getComponentName(), componentBrief.getComponentClass().getName(), componentBrief.getStereotype()));
    }

    public static interface Builder {
        public Builder setComponentName(String var1);

        public Builder setComponentClass(Class<?> var1);

        public Builder setStereotype(String var1);

        public ComponentBrief build();
    }
}

