/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.ioc;

import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.ioc.ComponentBrief;
import com.huawei.fitframework.ioc.ComponentRegistry;
import com.huawei.fitframework.ioc.ContainerType;
import com.huawei.fitframework.ioc.DependencyResolver;
import com.huawei.fitframework.ioc.NoSuchComponentException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface ComponentContainer {
    public ContainerType getContainerType();

    public void installRegistry(ComponentRegistry var1);

    public void observeRegistryInstalled(ComponentRegistry.InstalledObserver var1);

    public void uninstallRegistry(ComponentRegistry var1);

    public void observeRegistryUninstalled(ComponentRegistry.UninstalledObserver var1);

    public Optional<ComponentRegistry> getRegistry(String var1);

    public List<ComponentRegistry> getRegistries();

    public void addDependencyResolver(DependencyResolver var1);

    public void removeDependencyResolver(DependencyResolver var1);

    public DependencyResolver getDependencyResolver();

    public ComponentRegistry getRegistry();

    public Optional<ComponentBrief> getBrief(String var1);

    public Optional<ComponentBrief> getBrief(Class<?> var1);

    public List<ComponentBrief> listBriefs(Class<?> var1);

    public List<ComponentBrief> listBriefs();

    public Optional<Object> get(String var1, Object ... var2);

    public <T> Optional<T> get(Type var1, Object ... var2);

    default public <T> T require(String componentName, Object ... arguments) {
        return (T)this.get(componentName, arguments).orElseThrow(() -> new NoSuchComponentException(componentName));
    }

    default public <T> T require(Class<T> componentClass, Object ... arguments) {
        return this.require((Type)ObjectUtils.cast(componentClass), arguments);
    }

    default public <T> T require(Type componentType, Object ... arguments) {
        return this.get(componentType, arguments).orElseThrow(() -> new NoSuchComponentException(componentType));
    }

    default public <T> Map<String, T> list(Class<T> componentClass) {
        return this.list(componentClass, false);
    }

    default public <T> Map<String, T> list(Type componentType) {
        return this.list(componentType, true);
    }

    public <T> Map<String, T> list(Type var1, boolean var2);
}

