/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.ioc;

import com.huawei.fitframework.core.common.exception.ObjectInstantiationException;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.ioc.ComponentBrief;
import com.huawei.fitframework.ioc.ComponentContainer;
import com.huawei.fitframework.ioc.ComponentFactory;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public interface ComponentRegistry {
    public String getName();

    public ComponentContainer getContainer();

    public void register(ComponentBrief var1);

    default public void register(Object component) {
        this.register(null, component);
    }

    public void register(String var1, Object var2);

    public void register(ComponentFactory var1);

    public void observeComponentRegistered(Consumer<ComponentBrief> var1);

    public void unobserveComponentRegistered(Consumer<ComponentBrief> var1);

    public Optional<ComponentFactory> getComponentFactory(String var1);

    default public Optional<ComponentFactory> getComponentFactory(Class<?> componentClass) {
        List<ComponentFactory> factories = this.listComponentFactories(componentClass);
        if (factories.isEmpty()) {
            return Optional.empty();
        }
        if (factories.size() > 1) {
            throw new ObjectInstantiationException(StringUtils.format((String)"Multiply component briefs found for the specific class. [class={0}]", (Object[])new Object[]{componentClass.getName()}));
        }
        return Optional.of(factories.get(0));
    }

    default public Optional<ComponentFactory> getComponentFactory(Type componentType) {
        List<ComponentFactory> factories = this.listComponentFactories(componentType);
        if (factories.isEmpty()) {
            return Optional.empty();
        }
        if (factories.size() > 1) {
            throw new ObjectInstantiationException(StringUtils.format((String)"Multiply component briefs found for the specific class. [class={0}]", (Object[])new Object[]{componentType.getTypeName()}));
        }
        return Optional.of(factories.get(0));
    }

    public List<ComponentFactory> listComponentFactories(Class<?> var1);

    public List<ComponentFactory> listComponentFactories(Type var1);

    public List<ComponentFactory> listComponentFactories();

    public void preloadSingletons();

    public void scan(String ... var1);

    public void refresh();

    @FunctionalInterface
    public static interface UninstalledObserver {
        public void onRegistryUninstalled(ComponentRegistry var1);
    }

    @FunctionalInterface
    public static interface InstalledObserver {
        public void onRegistryInstalled(ComponentRegistry var1);
    }
}

