/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.ioc;

import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.ioc.ComponentBrief;
import com.huawei.fitframework.ioc.ComponentContainer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@FunctionalInterface
public interface ComponentResolver {
    public void resolve(Class<?> var1, Consumer<ComponentBrief> var2);

    public static ComponentResolver combine(ComponentResolver ... resolvers) {
        if (resolvers == null) {
            return null;
        }
        List actualResolvers = Arrays.stream(resolvers).filter(Objects::nonNull).collect(Collectors.toList());
        return (objectClass, componentDetectedCallback) -> {
            for (ComponentResolver resolver : actualResolvers) {
                resolver.resolve(objectClass, componentDetectedCallback);
            }
        };
    }

    public static ComponentResolver instantiate(Class<? extends Factory> factoryClass, ComponentContainer container) {
        return ((Factory)ReflectionUtils.instantiate(factoryClass)).create(container);
    }

    @FunctionalInterface
    public static interface Factory {
        public ComponentResolver create(ComponentContainer var1);
    }
}

