/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.ioc.support;

import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.ioc.ComponentBrief;
import com.huawei.fitframework.ioc.ComponentFactory;
import lombok.Generated;

public abstract class AbstractComponentFactory
implements ComponentFactory {
    private final String componentName;
    private final Class<?> componentClass;
    private final boolean singleton;
    private final String stereotype;

    public AbstractComponentFactory(ComponentBrief brief) {
        Validation.notNull((Object)brief, (String)"The brief of a component cannot be null.", (Object[])new Object[0]);
        this.componentName = Validation.notBlank((String)brief.getComponentName(), (String)"Name of a component cannot be null or an empty string.", (Object[])new Object[0]);
        this.componentClass = (Class)Validation.notNull(brief.getComponentClass(), (String)"Class of a component cannot be null.", (Object[])new Object[0]);
        this.singleton = brief.isSingleton();
        this.stereotype = brief.getStereotype();
    }

    public String toString() {
        return ComponentBrief.toString(this).orElse(null);
    }

    @Override
    @Generated
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    @Generated
    public Class<?> getComponentClass() {
        return this.componentClass;
    }

    @Override
    @Generated
    public boolean isSingleton() {
        return this.singleton;
    }

    @Override
    @Generated
    public String getStereotype() {
        return this.stereotype;
    }
}

