/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.ioc.support;

import com.huawei.fitframework.core.common.exception.MethodInvocationException;
import com.huawei.fitframework.core.common.exception.ObjectInstantiationException;
import com.huawei.fitframework.core.common.util.FunctionUtils;
import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.ioc.ComponentBrief;
import com.huawei.fitframework.ioc.ComponentFactory;
import com.huawei.fitframework.ioc.ComponentInitializationException;
import com.huawei.fitframework.ioc.DependencyResolver;
import com.huawei.fitframework.ioc.DependencyResolvingResult;
import com.huawei.fitframework.ioc.support.AbstractComponentFactory;
import com.huawei.fitframework.ioc.support.PrototypeComponentFactory;
import com.huawei.fitframework.ioc.support.SingletonComponentFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInjectableComponentFactory
extends AbstractComponentFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractInjectableComponentFactory.class);
    private final DependencyResolver dependencyResolver;
    private final Consumer<Object> fieldsInjector;
    private final Consumer<Object> componentInitializer;

    public AbstractInjectableComponentFactory(DependencyResolver dependencyResolver, ComponentBrief brief) {
        super(brief);
        this.dependencyResolver = (DependencyResolver)Validation.notNull((Object)dependencyResolver, (String)"The resolver for dependencies cannot be null.", (Object[])new Object[0]);
        this.fieldsInjector = this.createInjector(this.getDependencyResolver(), this.getComponentClass());
        this.componentInitializer = this.createInitializer(this.getComponentClass());
    }

    @Override
    public <T> T get(Object ... arguments) {
        log.debug("Constructing instance of component. {}", (Object)this);
        Object component = this.instantiate(arguments);
        this.injectFields(component);
        this.initializeComponent(component);
        return (T)component;
    }

    protected void injectFields(Object component) {
        if (this.fieldsInjector != null) {
            this.fieldsInjector.accept(component);
        }
    }

    private Consumer<Object> createInjector(DependencyResolver dependencyResolver, Class<?> componentClass) {
        Consumer injector = null;
        for (Class<?> clazz = componentClass; clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = ReflectionUtils.getDeclaredFields(clazz)) {
                injector = FunctionUtils.connect(injector, this.createInjector(dependencyResolver, field));
            }
        }
        return injector;
    }

    private Consumer<Object> createInjector(DependencyResolver dependencyResolver, Field field) {
        if (!dependencyResolver.isResolvable((ComponentBrief)this, field)) {
            return null;
        }
        return component -> {
            DependencyResolvingResult result = dependencyResolver.resolve(this, component, field);
            if (!result.isResolved()) {
                return;
            }
            try {
                ReflectionUtils.setField((Object)component, (Field)field, (Object)result.getValue());
            }
            catch (Throwable th) {
                log.error("Fail to inject field. [field={}, value={}]", (Object)field.getName(), result.getValue());
                throw th;
            }
        };
    }

    protected void initializeComponent(Object component) {
        if (this.componentInitializer != null) {
            this.componentInitializer.accept(component);
        }
    }

    protected Constructor<?> constructor(Class<?> ... argumentClasses) {
        Constructor[] constructors = ReflectionUtils.getDeclaredConstructors(this.getComponentClass());
        if (constructors.length == 1) {
            return constructors[0];
        }
        List<Constructor<?>> availableConstructors = this.filterConstructors(Arrays.asList(constructors), argumentClasses);
        if (availableConstructors.size() < 1) {
            throw new ObjectInstantiationException(StringUtils.format((String)"No matched constructor found. [class={0}, arguments=[{1}]]", (Object[])new Object[]{this.getComponentClass().getName(), StringUtils.join((String)", ", Class::getName, (Object[])argumentClasses)}));
        }
        if (availableConstructors.size() > 1) {
            throw new ObjectInstantiationException(StringUtils.format((String)"Multiply constructors matched for component. [class={0}, arguments=[{1}]]", (Object[])new Object[]{this.getComponentClass().getName(), StringUtils.join((String)", ", Class::getName, (Object[])argumentClasses)}));
        }
        return availableConstructors.get(0);
    }

    private List<Constructor<?>> filterConstructors(List<Constructor<?>> constructors, Class<?> ... argumentClasses) {
        List<Constructor<Object>> availableConstructors = constructors.stream().filter(constructor -> this.getDependencyResolver().isPreferredConstructor((Constructor<?>)constructor)).collect(Collectors.toList());
        if (availableConstructors.isEmpty()) {
            availableConstructors = constructors.stream().filter(constructor -> this.matchConstructor((Constructor<?>)constructor, argumentClasses)).collect(Collectors.toList());
        }
        return availableConstructors;
    }

    protected abstract boolean matchConstructor(Constructor<?> var1, Class<?> ... var2);

    private Consumer<Object> createInitializer(Class<?> componentClass) {
        Consumer initializer = null;
        for (Class<?> clazz = componentClass; clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = ReflectionUtils.getDeclaredMethods(clazz)) {
                initializer = FunctionUtils.connect(initializer, this.createInitializer(method));
            }
        }
        return initializer;
    }

    private Consumer<Object> createInitializer(Method method) {
        if (!AbstractInjectableComponentFactory.isInitializingMethod(method)) {
            return null;
        }
        if (method.getParameterCount() > 0) {
            throw new IllegalStateException(StringUtils.format((String)"Initialize method cannot accept any arguments. [signature={0}]", (Object[])new Object[]{ReflectionUtils.toString((Method)method)}));
        }
        return component -> {
            try {
                method.setAccessible(true);
                ReflectionUtils.invoke((Object)component, (Method)method, (Object[])new Object[0]);
            }
            catch (MethodInvocationException ex) {
                throw new ComponentInitializationException(method, (Throwable)ex);
            }
        };
    }

    private static boolean isInitializingMethod(Method method) {
        return !Modifier.isStatic(method.getModifiers()) && method.isAnnotationPresent(PostConstruct.class);
    }

    protected abstract Object instantiate(Object ... var1);

    static ComponentFactory create(DependencyResolver dependencyResolver, ComponentBrief brief) {
        if (brief.isSingleton()) {
            return new SingletonComponentFactory(dependencyResolver, brief);
        }
        return new PrototypeComponentFactory(dependencyResolver, brief);
    }

    @Generated
    protected DependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }
}

