/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.ioc.support;

import com.huawei.fitframework.core.common.exception.ObjectInstantiationException;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.ioc.ComponentBrief;
import com.huawei.fitframework.ioc.ComponentContainer;
import com.huawei.fitframework.ioc.DependencyResolver;
import com.huawei.fitframework.ioc.DependencyResolvingResult;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ComponentDependencyResolver
implements DependencyResolver {
    private final ComponentContainer container;

    public ComponentDependencyResolver(ComponentContainer container) {
        this.container = (ComponentContainer)Validation.notNull((Object)container, (String)"The container of a autowired dependency resolver cannot be null.", (Object[])new Object[0]);
    }

    @Override
    public boolean isPreferredConstructor(Constructor<?> constructor) {
        return false;
    }

    @Override
    public boolean isResolvable(ComponentBrief summary, Parameter parameter) {
        return false;
    }

    @Override
    public boolean isResolvable(ComponentBrief summary, Field field) {
        return false;
    }

    @Override
    public DependencyResolvingResult resolve(ComponentBrief summary, Parameter parameter) {
        return this.resolve(parameter.getParameterizedType());
    }

    @Override
    public DependencyResolvingResult resolve(ComponentBrief summary, Object bean, Field field) {
        return this.resolve(field.getGenericType());
    }

    private DependencyResolvingResult resolve(Type requiredType) {
        Object resolved = this.resolveByType(requiredType);
        if (resolved == null) {
            return DependencyResolvingResult.failure();
        }
        return DependencyResolvingResult.create(resolved);
    }

    private Object resolveByType(Type requiredType) {
        if (requiredType instanceof ParameterizedType) {
            return this.resolveByParameterizedType((ParameterizedType)requiredType);
        }
        if (requiredType instanceof Class) {
            return this.container.getBrief((Class)requiredType).map(this::resolve).orElse(null);
        }
        throw new ObjectInstantiationException(StringUtils.format((String)"Cannot resolve dependency by type. [class={0}]", (Object[])new Object[]{requiredType}));
    }

    private Object resolveByParameterizedType(ParameterizedType parameterizedType) {
        Type rawType = parameterizedType.getRawType();
        Object[] argumentTypes = parameterizedType.getActualTypeArguments();
        if (rawType == List.class && (argumentTypes.length == 1 || argumentTypes[0] instanceof Class)) {
            return this.container.listBriefs((Class)argumentTypes[0]).stream().map(this::resolve).collect(Collectors.toList());
        }
        if (rawType == Map.class && argumentTypes.length == 2 && argumentTypes[0] == String.class && argumentTypes[1] instanceof Class) {
            return this.container.listBriefs((Class)argumentTypes[1]).stream().collect(Collectors.toMap(ComponentBrief::getComponentName, this::resolve));
        }
        throw new ObjectInstantiationException(StringUtils.format((String)"Cannot resolve dependency. [class={0}<{1}>]", (Object[])new Object[]{rawType.getTypeName(), StringUtils.join((String)", ", (Object[])argumentTypes)}));
    }

    private Object resolve(ComponentBrief brief) {
        return brief == null ? null : this.container.get(brief.getComponentName(), new Object[0]).orElse(null);
    }
}

