/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.ioc.support;

import com.huawei.fitframework.core.common.util.LockUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.ioc.ComponentBrief;
import com.huawei.fitframework.ioc.ComponentContainer;
import com.huawei.fitframework.ioc.ComponentFactory;
import com.huawei.fitframework.ioc.ComponentRegistry;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;

public class ComponentRegistryComposite
implements ComponentRegistry {
    private final ComponentRegistry baseRegistry;
    private final List<ComponentRegistry> children;
    private final ReadWriteLock lock;

    public ComponentRegistryComposite(ComponentRegistry baseRegistry) {
        this.baseRegistry = (ComponentRegistry)Validation.notNull((Object)baseRegistry, (String)"The base registry of a composite cannot be null.", (Object[])new Object[0]);
        this.children = new ArrayList<ComponentRegistry>();
        this.lock = LockUtils.newReentrantReadWriteLock();
    }

    public void addRegistry(ComponentRegistry registry) {
        Validation.notNull((Object)registry, (String)"The registry to add cannot be null.", (Object[])new Object[0]);
        LockUtils.synchronize((Lock)this.lock.writeLock(), () -> this.children.add(registry));
    }

    public void removeRegistry(ComponentRegistry registry) {
        Validation.notNull((Object)registry, (String)"The registry to remove cannot be null.", (Object[])new Object[0]);
        LockUtils.synchronize((Lock)this.lock.writeLock(), () -> this.children.remove(registry));
    }

    public List<ComponentRegistry> getRegistries() {
        return (List)LockUtils.synchronize((Lock)this.lock.readLock(), () -> Collections.unmodifiableList(new ArrayList<ComponentRegistry>(this.children)));
    }

    @Override
    public final ComponentContainer getContainer() {
        return this.baseRegistry.getContainer();
    }

    @Override
    public final String getName() {
        return this.baseRegistry.getName() + ":composite";
    }

    @Override
    public final void register(ComponentBrief brief) {
        this.baseRegistry.register(brief);
    }

    @Override
    public final void register(String componentName, Object component) {
        this.baseRegistry.register(componentName, component);
    }

    @Override
    public final void register(ComponentFactory factory) {
        this.baseRegistry.register(factory);
    }

    @Override
    public void observeComponentRegistered(Consumer<ComponentBrief> observer) {
        this.baseRegistry.observeComponentRegistered(observer);
    }

    @Override
    public void unobserveComponentRegistered(Consumer<ComponentBrief> observer) {
        this.baseRegistry.unobserveComponentRegistered(observer);
    }

    @Override
    public final Optional<ComponentFactory> getComponentFactory(String componentName) {
        Optional summary = (Optional)LockUtils.synchronize((Lock)this.lock.readLock(), () -> {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                Optional<ComponentFactory> optional = this.children.get(i).getComponentFactory(componentName);
                if (!optional.isPresent()) continue;
                return optional;
            }
            return Optional.empty();
        });
        if (summary.isPresent()) {
            return summary;
        }
        return this.baseRegistry.getComponentFactory(componentName);
    }

    @Override
    public final List<ComponentFactory> listComponentFactories(Class<?> componentClass) {
        return this.list(registry -> registry.listComponentFactories(componentClass));
    }

    @Override
    public final List<ComponentFactory> listComponentFactories(Type componentType) {
        return this.list(registry -> registry.listComponentFactories(componentType));
    }

    @Override
    public final List<ComponentFactory> listComponentFactories() {
        return this.list(ComponentRegistry::listComponentFactories);
    }

    @Override
    public void preloadSingletons() {
        this.baseRegistry.preloadSingletons();
        this.children.forEach(ComponentRegistry::preloadSingletons);
    }

    @Override
    public void scan(String ... packages) {
        this.getRegistries().forEach(registry -> registry.scan(packages));
    }

    @Override
    public void refresh() {
        this.getRegistries().forEach(ComponentRegistry::refresh);
    }

    private List<ComponentFactory> list(Function<ComponentRegistry, List<ComponentFactory>> fetcher) {
        HashMap<String, ComponentFactory> summaries = new HashMap<String, ComponentFactory>();
        LockUtils.synchronize((Lock)this.lock.readLock(), () -> {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                ComponentRegistryComposite.append(summaries, (List)fetcher.apply(this.children.get(i)));
            }
        });
        ComponentRegistryComposite.append(summaries, fetcher.apply(this.baseRegistry));
        return new ArrayList<ComponentFactory>(summaries.values());
    }

    private static void append(Map<String, ComponentFactory> cache, List<ComponentFactory> summaries) {
        for (ComponentFactory summary : summaries) {
            cache.putIfAbsent(summary.getComponentName(), summary);
        }
    }

    @Generated
    public ComponentRegistry getBaseRegistry() {
        return this.baseRegistry;
    }
}

