/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.ioc.support;

import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.ioc.ComponentBrief;
import com.huawei.fitframework.ioc.ComponentContainer;
import com.huawei.fitframework.ioc.ComponentFactory;
import com.huawei.fitframework.ioc.ComponentRegistry;
import com.huawei.fitframework.ioc.ContainerType;
import com.huawei.fitframework.ioc.DependencyResolver;
import com.huawei.fitframework.ioc.support.ComponentBriefWrapper;
import com.huawei.fitframework.ioc.support.ComponentRegistryComposite;
import com.huawei.fitframework.ioc.support.DefaultComponentRegistry;
import com.huawei.fitframework.ioc.support.DependencyResolverComposite;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultComponentContainer
implements ComponentContainer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultComponentContainer.class);
    private static final String BASE_REGISTRY_NAME = "component-container:default-registry";
    private final List<ComponentRegistry.InstalledObserver> registryInstalledObservers;
    private final List<ComponentRegistry.UninstalledObserver> registryUninstalledObservers;
    private final ComponentRegistryComposite registry = new ComponentRegistryComposite(new DefaultComponentRegistry(this, "component-container:default-registry"));
    private final ContainerType containerType;
    private DependencyResolver dependencyResolver;

    public DefaultComponentContainer(String containerType) {
        this.registry.register(this);
        this.registryInstalledObservers = new ArrayList<ComponentRegistry.InstalledObserver>();
        this.registryUninstalledObservers = new ArrayList<ComponentRegistry.UninstalledObserver>();
        this.containerType = (ContainerType)ObjectUtils.nullIf((Object)ContainerType.fromCode((String)containerType), (Object)ContainerType.FIT);
        log.info("Container type is {}, actually use Enum {}.", (Object)containerType, (Object)this.containerType.name());
    }

    @Override
    public ContainerType getContainerType() {
        return this.containerType;
    }

    @Override
    public void installRegistry(ComponentRegistry registry) {
        Validation.notNull((Object)registry, (String)"The component registry to install cannot be null.", (Object[])new Object[0]);
        if (registry.getContainer() != this) {
            throw new IllegalArgumentException("The registry to install does not belong to the current container.");
        }
        log.debug("Installing component registry: [name={}]", (Object)registry.getName());
        this.registry.addRegistry(registry);
        log.debug("Component registry installed. [name={}]", (Object)registry.getName());
        this.registryInstalledObservers.forEach(observer -> observer.onRegistryInstalled(registry));
    }

    @Override
    public void observeRegistryInstalled(ComponentRegistry.InstalledObserver observer) {
        if (observer != null) {
            this.registryInstalledObservers.add(observer);
        }
    }

    @Override
    public void uninstallRegistry(ComponentRegistry registry) {
        Validation.notNull((Object)registry, (String)"The component registry to uninstall cannot be null.", (Object[])new Object[0]);
        if (registry.getContainer() != this) {
            throw new IllegalArgumentException("The registry to uninstall does not belongs to the current container.");
        }
        log.debug("Uninstalling component registry: [name={}]", (Object)registry.getName());
        this.registry.removeRegistry(registry);
        log.debug("Component registry uninstalled. [name={}]", (Object)registry.getName());
        this.registryUninstalledObservers.forEach(observer -> observer.onRegistryUninstalled(registry));
    }

    @Override
    public void observeRegistryUninstalled(ComponentRegistry.UninstalledObserver observer) {
        if (observer != null) {
            this.registryUninstalledObservers.add(observer);
        }
    }

    @Override
    public List<ComponentRegistry> getRegistries() {
        ArrayList<ComponentRegistry> registries = new ArrayList<ComponentRegistry>(this.registry.getRegistries());
        registries.add(this.registry.getBaseRegistry());
        return Collections.unmodifiableList(registries);
    }

    @Override
    public Optional<ComponentRegistry> getRegistry(String name) {
        return this.getRegistries().stream().filter(registry -> StringUtils.equals((String)registry.getName(), (String)name)).findAny();
    }

    @Override
    public void addDependencyResolver(DependencyResolver resolver) {
        this.dependencyResolver = DependencyResolverComposite.combine(this.dependencyResolver, resolver);
    }

    @Override
    public void removeDependencyResolver(DependencyResolver resolver) {
        this.dependencyResolver = DependencyResolverComposite.remove(this.dependencyResolver, resolver);
    }

    @Override
    public DependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    @Override
    public Optional<ComponentBrief> getBrief(String componentName) {
        return this.registry.getComponentFactory(componentName).map(ComponentBriefWrapper::wrap);
    }

    @Override
    public Optional<ComponentBrief> getBrief(Class<?> componentClass) {
        return this.registry.getComponentFactory(componentClass).map(ComponentBriefWrapper::wrap);
    }

    @Override
    public List<ComponentBrief> listBriefs(Class<?> componentClass) {
        return this.registry.listComponentFactories(componentClass).stream().map(ComponentBriefWrapper::wrap).collect(Collectors.toList());
    }

    @Override
    public List<ComponentBrief> listBriefs() {
        return this.registry.listComponentFactories().stream().map(ComponentBriefWrapper::wrap).collect(Collectors.toList());
    }

    @Override
    public Optional<Object> get(String componentName, Object ... arguments) {
        return this.registry.getComponentFactory(componentName).map(factory -> DefaultComponentRegistry.instantiate(factory, arguments));
    }

    @Override
    public <T> Optional<T> get(Type componentType, Object ... arguments) {
        return this.registry.getComponentFactory(componentType).map(factory -> DefaultComponentRegistry.instantiate(factory, arguments));
    }

    @Override
    public <T> Map<String, T> list(Type componentType, boolean includePrototypes) {
        List<ComponentFactory> factories = this.registry.listComponentFactories(componentType);
        if (!includePrototypes) {
            factories = factories.stream().filter(ComponentBrief::isSingleton).collect(Collectors.toList());
        }
        return factories.stream().collect(Collectors.toMap(ComponentBrief::getComponentName, x$0 -> DefaultComponentRegistry.instantiate(x$0, new Object[0])));
    }

    @Override
    @Generated
    public ComponentRegistryComposite getRegistry() {
        return this.registry;
    }
}

