/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.ioc.support;

import com.huawei.fitframework.core.common.type.TypeMatcher;
import com.huawei.fitframework.core.common.util.LockUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.ioc.ComponentBrief;
import com.huawei.fitframework.ioc.ComponentContainer;
import com.huawei.fitframework.ioc.ComponentCreationException;
import com.huawei.fitframework.ioc.ComponentFactory;
import com.huawei.fitframework.ioc.ComponentRegistry;
import com.huawei.fitframework.ioc.DependencyResolver;
import com.huawei.fitframework.ioc.support.AbstractInjectableComponentFactory;
import com.huawei.fitframework.ioc.support.DirectComponentFactory;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultComponentRegistry
implements ComponentRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultComponentRegistry.class);
    private final ComponentContainer container;
    private final String name;
    private final Map<String, ComponentFactory> factories;
    private final ReadWriteLock lock;
    private final List<Consumer<ComponentBrief>> componentRegisteredObservers;

    public DefaultComponentRegistry(ComponentContainer container, String name) {
        this.container = (ComponentContainer)Validation.notNull((Object)container, (String)"Container of a component registry cannot be null.", (Object[])new Object[0]);
        this.name = Validation.notBlank((String)name, (String)"Name of a component registry cannot be blank.", (Object[])new Object[0]);
        this.factories = new HashMap<String, ComponentFactory>();
        this.lock = LockUtils.newReentrantReadWriteLock();
        this.componentRegisteredObservers = new ArrayList<Consumer<ComponentBrief>>();
    }

    private DependencyResolver getDependencyResolver() {
        return this.getContainer().getDependencyResolver();
    }

    @Override
    public final ComponentContainer getContainer() {
        return this.container;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public void register(ComponentBrief brief) {
        Validation.notNull((Object)brief, (String)"The brief of component to register cannot be null.", (Object[])new Object[0]);
        ComponentFactory factory = AbstractInjectableComponentFactory.create(this.getDependencyResolver(), brief);
        this.register(factory);
    }

    @Override
    public void register(String componentName, Object component) {
        Validation.notNull((Object)component, (String)"The component to register cannot be null.", (Object[])new Object[0]);
        ComponentFactory factory = component instanceof ComponentFactory ? (ComponentFactory)component : new DirectComponentFactory(componentName, component);
        this.register(factory);
    }

    @Override
    public void register(ComponentFactory factory) {
        Validation.notNull((Object)factory, (String)"The factory of component to register cannot be null.", (Object[])new Object[0]);
        log.debug("Registering component [name={}, class={}, singleton={}] ...", new Object[]{factory.getComponentName(), factory.getComponentClass().getName(), factory.isSingleton()});
        LockUtils.synchronize((Lock)this.lock.writeLock(), () -> {
            if (this.factories.containsKey(factory.getComponentName())) {
                throw new IllegalStateException(StringUtils.format((String)"A component with the same name already exists. [name={0}]", (Object[])new Object[]{factory.getComponentName()}));
            }
            this.factories.put(factory.getComponentName(), factory);
        });
        this.componentRegisteredObservers.forEach(consumer -> consumer.accept(factory));
    }

    @Override
    public void observeComponentRegistered(Consumer<ComponentBrief> observer) {
        if (observer != null) {
            this.componentRegisteredObservers.add(observer);
        }
    }

    @Override
    public void unobserveComponentRegistered(Consumer<ComponentBrief> observer) {
        if (observer != null) {
            this.componentRegisteredObservers.remove(observer);
        }
    }

    @Override
    public Optional<ComponentFactory> getComponentFactory(String componentName) {
        if (componentName == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(LockUtils.synchronize((Lock)this.lock.readLock(), () -> this.factories.get(componentName)));
    }

    @Override
    public List<ComponentFactory> listComponentFactories(Class<?> componentClass) {
        if (componentClass == null) {
            return Collections.emptyList();
        }
        return (List)LockUtils.synchronize((Lock)this.lock.readLock(), () -> this.factories.values().stream().filter(factory -> componentClass.isAssignableFrom(factory.getComponentClass())).collect(Collectors.toList()));
    }

    @Override
    public List<ComponentFactory> listComponentFactories(Type componentType) {
        if (componentType == null) {
            return Collections.emptyList();
        }
        return (List)LockUtils.synchronize((Lock)this.lock.readLock(), () -> this.factories.values().stream().filter(factory -> TypeMatcher.match(factory.getComponentClass(), (Type)componentType)).collect(Collectors.toList()));
    }

    @Override
    public List<ComponentFactory> listComponentFactories() {
        return (List)LockUtils.synchronize((Lock)this.lock.readLock(), () -> Collections.unmodifiableList(new ArrayList<ComponentFactory>(this.factories.values())));
    }

    @Override
    public void preloadSingletons() {
        log.debug("Preloading singleton components. [registry={}]", (Object)this.name);
        int count = 0;
        for (ComponentFactory factory : this.listComponentFactories()) {
            if (!factory.isSingleton()) continue;
            DefaultComponentRegistry.instantiate(factory, new Object[0]);
            ++count;
        }
        log.debug("Singleton components preloaded. Total {} components loaded!", (Object)count);
    }

    public static <T> T instantiate(ComponentFactory factory, Object ... arguments) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(factory.getComponentClass().getClassLoader());
            Object t = factory.get(arguments);
            return t;
        }
        catch (Throwable t) {
            log.error("Fail to instantiate component. {}", (Object)factory);
            if (t instanceof ComponentCreationException) {
                throw (ComponentCreationException)t;
            }
            throw new ComponentCreationException(factory.getComponentClass(), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    @Override
    public void scan(String ... packages) {
    }

    @Override
    public void refresh() {
    }
}

