/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.ioc.support;

import com.huawei.fitframework.core.common.util.FunctionUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.core.common.util.support.UrlClassLoaderScanner;
import com.huawei.fitframework.ioc.ComponentBrief;
import com.huawei.fitframework.ioc.ComponentRegistry;
import com.huawei.fitframework.ioc.ComponentResolver;
import com.huawei.fitframework.ioc.ComponentScanner;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultComponentScanner
implements ComponentScanner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultComponentScanner.class);
    private final URLClassLoader classLoader;
    private Predicate<String> classNameFilter;
    private Predicate<URL> urlFilter;
    private ComponentResolver componentResolver;

    public DefaultComponentScanner(URLClassLoader classLoader) {
        this.classLoader = (URLClassLoader)Validation.notNull((Object)classLoader, (String)"The class loader to scan class cannot be null.", (Object[])new Object[0]);
    }

    @Override
    public void scan(ComponentRegistry registry) {
        UrlClassLoaderScanner scanner = new UrlClassLoaderScanner(this.classLoader, this.urlFilter);
        scanner.addClassNameFilter(this.classNameFilter);
        scanner.addClassDetectedObserver(className -> this.onClassDetected((String)className, registry::register));
        scanner.scan();
    }

    private void onClassDetected(String className, Consumer<ComponentBrief> briefConsumer) {
        Class<?> objectClass;
        try {
            objectClass = this.classLoader.loadClass(className);
        }
        catch (Throwable ignored) {
            log.warn("Fail to load class. [className={}]", (Object)className);
            return;
        }
        this.componentResolver.resolve(objectClass, briefConsumer);
    }

    @Override
    public void addClassNameFilter(Predicate<String> classNameFilter) {
        this.classNameFilter = FunctionUtils.and(this.classNameFilter, classNameFilter);
    }

    @Override
    public void addUrlFilter(Predicate<URL> urlFilter) {
        this.urlFilter = FunctionUtils.and(this.urlFilter, urlFilter);
    }

    @Override
    public void addComponentResolver(ComponentResolver componentResolver) {
        this.componentResolver = ComponentResolver.combine(this.componentResolver, componentResolver);
    }

    public static class Factory
    implements ComponentScanner.Factory {
        @Override
        public ComponentScanner create(ClassLoader classLoader) {
            if (classLoader instanceof URLClassLoader) {
                return new DefaultComponentScanner((URLClassLoader)classLoader);
            }
            throw new IllegalArgumentException("The class loader to scan is not a URL class loader.");
        }
    }
}

