/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.ioc.support;

import com.huawei.fitframework.ioc.ComponentBrief;
import com.huawei.fitframework.ioc.DependencyResolver;
import com.huawei.fitframework.ioc.DependencyResolvingResult;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.util.function.Function;
import java.util.function.Predicate;

public class DependencyResolverComposite
implements DependencyResolver {
    private final DependencyResolver resolver1;
    private final DependencyResolver resolver2;

    public DependencyResolverComposite(DependencyResolver resolver1, DependencyResolver resolver2) {
        this.resolver1 = resolver1;
        this.resolver2 = resolver2;
    }

    @Override
    public boolean isPreferredConstructor(Constructor<?> constructor) {
        return this.test(resolver -> resolver.isPreferredConstructor(constructor));
    }

    @Override
    public boolean isResolvable(ComponentBrief brief, Parameter parameter) {
        return this.test(resolver -> resolver.isResolvable(brief, parameter));
    }

    @Override
    public boolean isResolvable(ComponentBrief brief, Field field) {
        return this.test(resolver -> resolver.isResolvable(brief, field));
    }

    @Override
    public DependencyResolvingResult resolve(ComponentBrief brief, Parameter parameter) {
        return this.resolve(resolver -> resolver.resolve(brief, parameter));
    }

    @Override
    public DependencyResolvingResult resolve(ComponentBrief brief, Object bean, Field field) {
        return this.resolve(resolver -> resolver.resolve(brief, bean, field));
    }

    private boolean test(Predicate<DependencyResolver> predicate) {
        return predicate.test(this.resolver1) || predicate.test(this.resolver2);
    }

    private DependencyResolvingResult resolve(Function<DependencyResolver, DependencyResolvingResult> resolver) {
        DependencyResolvingResult result = resolver.apply(this.resolver1);
        if (result.isResolved()) {
            return result;
        }
        return resolver.apply(this.resolver2);
    }

    public static DependencyResolver combine(DependencyResolver resolver1, DependencyResolver resolver2) {
        if (resolver1 == null) {
            return resolver2;
        }
        if (resolver2 == null) {
            return resolver1;
        }
        return new DependencyResolverComposite(resolver1, resolver2);
    }

    public static DependencyResolver remove(DependencyResolver resolver1, DependencyResolver resolver2) {
        if (resolver1 instanceof DependencyResolverComposite) {
            DependencyResolverComposite composite = (DependencyResolverComposite)resolver1;
            if (composite.resolver1 == resolver2) {
                return composite.resolver2;
            }
            if (composite.resolver2 == resolver2) {
                return composite.resolver1;
            }
        }
        return resolver1;
    }
}

