/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.ioc.support;

import com.huawei.fitframework.core.common.exception.ObjectInstantiationException;
import com.huawei.fitframework.core.common.util.ArrayUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.ioc.ComponentBrief;
import com.huawei.fitframework.ioc.support.AbstractComponentFactory;

public class DirectComponentFactory
extends AbstractComponentFactory {
    private final Object component;

    public DirectComponentFactory(String componentName, Object component) {
        super(DirectComponentFactory.createSummary(componentName, component));
        this.component = component;
    }

    private static ComponentBrief createSummary(String name, Object component) {
        Validation.notNull((Object)component, (String)"The component to create factory cannot be null.", (Object[])new Object[0]);
        return ComponentBrief.builder().setComponentName(StringUtils.isBlank((String)name) ? component.getClass().getName() : name).setComponentClass(component.getClass()).setStereotype("singleton").build();
    }

    @Override
    public <T> T get(Object ... arguments) {
        if (ArrayUtils.isNotEmpty((Object[])arguments)) {
            throw new ObjectInstantiationException(StringUtils.format((String)"Cannot construct a singleton component with initial arguments. [class={0}]", (Object[])new Object[]{this.getComponentClass().getName()}));
        }
        return (T)this.component;
    }
}

