/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.ioc.support;

import com.huawei.fitframework.core.common.util.LockUtils;
import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.ioc.ComponentBrief;
import com.huawei.fitframework.ioc.DependencyResolver;
import com.huawei.fitframework.ioc.support.AbstractInjectableComponentFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;

class PrototypeComponentFactory
extends AbstractInjectableComponentFactory {
    private final Map<Constructor<?>, Factory> factories = new HashMap();
    private final Lock lock = LockUtils.newReentrantLock();

    PrototypeComponentFactory(DependencyResolver dependencyResolver, ComponentBrief summary) {
        super(dependencyResolver, summary);
    }

    @Override
    protected Object instantiate(Object ... arguments) {
        Class<?>[] argumentClasses = this.argumentClasses(arguments);
        Constructor<?> constructor = this.constructor(argumentClasses);
        return this.factory(constructor).create(arguments);
    }

    @Override
    protected boolean matchConstructor(Constructor<?> constructor, Class<?>[] argumentClasses) {
        Parameter[] parameters = ReflectionUtils.getParameters(constructor);
        if (parameters.length < argumentClasses.length) {
            return false;
        }
        int argumentIndex = 0;
        for (Parameter parameter : parameters) {
            if (this.getDependencyResolver().isResolvable((ComponentBrief)this, parameter)) continue;
            if (PrototypeComponentFactory.match(parameter.getType(), argumentClasses, argumentIndex)) {
                ++argumentIndex;
                continue;
            }
            return false;
        }
        return argumentIndex == argumentClasses.length;
    }

    private static boolean match(Class<?> parameterClass, Class<?>[] argumentClasses, int argumentIndex) {
        if (argumentIndex < argumentClasses.length) {
            Class<?> argumentClass = argumentClasses[argumentIndex];
            if (argumentClass == null) {
                return !parameterClass.isPrimitive();
            }
            return parameterClass.isAssignableFrom(argumentClass);
        }
        return false;
    }

    private Class<?>[] argumentClasses(Object[] arguments) {
        Class[] argumentClasses = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Object argument = arguments[i];
            argumentClasses[i] = argument == null ? null : argument.getClass();
        }
        return argumentClasses;
    }

    private Factory factory(Constructor<?> constructor) {
        return (Factory)LockUtils.synchronize((Lock)this.lock, () -> {
            Factory factory = this.factories.get(constructor);
            if (factory == null) {
                factory = Factory.create(this, constructor);
                this.factories.put(constructor, factory);
            }
            return factory;
        });
    }

    private static class UserInputArgument
    extends Argument {
        private final int argumentIndex;

        UserInputArgument(PrototypeComponentFactory holder, Parameter parameter, int argumentIndex) {
            super(holder, parameter);
            this.argumentIndex = argumentIndex;
        }

        @Override
        Object get(Object ... arguments) {
            return arguments[this.argumentIndex];
        }
    }

    private static class ResolvableArgument
    extends Argument {
        ResolvableArgument(PrototypeComponentFactory holder, Parameter parameter) {
            super(holder, parameter);
        }

        @Override
        Object get(Object ... arguments) {
            return this.dependencyResolver().resolve(this.factory(), this.parameter()).getValue();
        }
    }

    private static abstract class Argument {
        private final PrototypeComponentFactory holder;
        private final Parameter parameter;

        Argument(PrototypeComponentFactory holder, Parameter parameter) {
            this.holder = holder;
            this.parameter = parameter;
        }

        final PrototypeComponentFactory factory() {
            return this.holder;
        }

        final Parameter parameter() {
            return this.parameter;
        }

        final DependencyResolver dependencyResolver() {
            return this.factory().getDependencyResolver();
        }

        abstract Object get(Object ... var1);
    }

    private static class Factory {
        private final Constructor<?> constructor;
        private final List<Argument> arguments;

        private Factory(Constructor<?> constructor, List<Argument> arguments) {
            this.constructor = constructor;
            this.arguments = arguments;
        }

        Object create(Object ... arguments) {
            return ReflectionUtils.instantiate(this.constructor, (Object[])this.arguments.stream().map(argument -> argument.get(arguments)).toArray(Object[]::new));
        }

        static Factory create(PrototypeComponentFactory factory, Constructor<?> constructor) {
            Parameter[] parameters = ReflectionUtils.getParameters(constructor);
            ArrayList<Argument> initialArguments = new ArrayList<Argument>(parameters.length);
            int userInputArgumentIndex = 0;
            for (Parameter parameter : parameters) {
                if (factory.getDependencyResolver().isResolvable((ComponentBrief)factory, parameter)) {
                    initialArguments.add(new ResolvableArgument(factory, parameter));
                    continue;
                }
                initialArguments.add(new UserInputArgument(factory, parameter, userInputArgumentIndex++));
            }
            return new Factory(constructor, initialArguments);
        }
    }
}

