/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.ioc.support;

import com.huawei.fitframework.core.common.exception.ObjectInstantiationException;
import com.huawei.fitframework.core.common.util.ArrayUtils;
import com.huawei.fitframework.core.common.util.LockUtils;
import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.ioc.CircularDependencyException;
import com.huawei.fitframework.ioc.ComponentBrief;
import com.huawei.fitframework.ioc.ComponentCreationException;
import com.huawei.fitframework.ioc.DependencyResolver;
import com.huawei.fitframework.ioc.UnresolvableDependencyException;
import com.huawei.fitframework.ioc.support.AbstractInjectableComponentFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SingletonComponentFactory
extends AbstractInjectableComponentFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SingletonComponentFactory.class);
    private volatile Object instance = null;
    private boolean creating = false;
    private final Lock lock = LockUtils.newReentrantLock();
    private Object creatingComponent;

    SingletonComponentFactory(DependencyResolver dependencyResolver, ComponentBrief summary) {
        super(dependencyResolver, summary);
    }

    @Override
    public <T> T get(Object ... arguments) {
        if (ArrayUtils.isNotEmpty((Object[])arguments)) {
            throw new ObjectInstantiationException(StringUtils.format((String)"Cannot construct a singleton component with initial arguments. [class={0}]", (Object[])new Object[]{this.getComponentClass().getName()}));
        }
        if (this.instance == null) {
            LockUtils.synchronize((Lock)this.lock, () -> {
                if (this.instance == null) {
                    this.instance = this.create();
                }
            });
        }
        return (T)this.instance;
    }

    private Object create() {
        if (this.creating) {
            if (this.creatingComponent == null) {
                throw new CircularDependencyException(StringUtils.format((String)"Circular dependency occurs for singleton component. [class={0}]", (Object[])new Object[]{this.getComponentClass().getName()}));
            }
            return this.creatingComponent;
        }
        this.creating = true;
        try {
            Object t = super.get(new Object[0]);
            return t;
        }
        finally {
            this.creatingComponent = null;
            this.creating = false;
        }
    }

    @Override
    protected Object instantiate(Object ... initialArguments) {
        Constructor<?> constructor = this.constructor(new Class[0]);
        Parameter[] parameters = ReflectionUtils.getParameters(constructor);
        Object[] arguments = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            try {
                arguments[i] = this.getDependencyResolver().resolve(this, parameters[i]).getValue();
                continue;
            }
            catch (Throwable t) {
                Throwable cause = t;
                if (cause instanceof ComponentCreationException) {
                    cause = cause.getCause();
                }
                throw new UnresolvableDependencyException(StringUtils.format((String)"Fail to resolve dependency. [class={0}, parameter={1}]", (Object[])new Object[]{this.getComponentClass().getName(), parameters[i].getName()}), cause);
            }
        }
        this.creatingComponent = ReflectionUtils.instantiate(constructor, (Object[])arguments);
        return this.creatingComponent;
    }

    @Override
    protected boolean matchConstructor(Constructor<?> constructor, Class<?> ... argumentClasses) {
        return Arrays.stream(ReflectionUtils.getParameters(constructor)).allMatch(parameter -> this.getDependencyResolver().isResolvable((ComponentBrief)this, (Parameter)parameter));
    }

    @Generated
    public boolean isCreating() {
        return this.creating;
    }
}

