/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.http.supplier.support;

import com.huawei.fit.sdk.context.GetGlobalContext;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.http.entity.Cookie;
import com.huawei.fitframework.http.entity.HttpRequest;
import com.huawei.fitframework.http.entity.support.DefaultHttpRequest;
import com.huawei.fitframework.http.supplier.HttpRequestSupplier;
import com.huawei.fitframework.serialization.JsonSerializer;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Fitable
public class DefaultHttpRequestSupplier
implements HttpRequestSupplier {
    private static final String HTTP_REQUEST = "HTTP_REQUEST";
    private final GetGlobalContext getGlobalContext;
    private final JsonSerializer jsonSerializer;

    DefaultHttpRequestSupplier(@Fit GetGlobalContext getGlobalContext, @Fit JsonSerializer jsonSerializer) {
        this.getGlobalContext = getGlobalContext;
        this.jsonSerializer = jsonSerializer;
    }

    public HttpRequest get() {
        Map map = this.jsonSerializer.deserialize2Map(this.getGlobalContext.process(HTTP_REQUEST));
        return this.map2HttpRequest(map);
    }

    private HttpRequest map2HttpRequest(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        return DefaultHttpRequest.builder().method((String)ObjectUtils.cast((Object)map.get("method"))).requestURI((String)ObjectUtils.cast((Object)map.get("requestURI"))).queryString((String)ObjectUtils.cast((Object)map.get("queryString"))).protocol((String)ObjectUtils.cast((Object)map.get("protocol"))).remoteAddr((String)ObjectUtils.cast((Object)map.get("remoteAddr"))).remotePort(((Integer)ObjectUtils.cast((Object)map.get("remotePort"))).intValue()).remoteHost((String)ObjectUtils.cast((Object)map.get("remoteHost"))).localAddr((String)ObjectUtils.cast((Object)map.get("localAddr"))).localName((String)ObjectUtils.cast((Object)map.get("localName"))).localPort(((Integer)ObjectUtils.cast((Object)map.get("localPort"))).intValue()).scheme((String)ObjectUtils.cast((Object)map.get("scheme"))).requestURL(new StringBuilder(String.valueOf(map.get("requestURL")))).cookies(this.buildCookies(map.get("cookies"))).headers((Map)ObjectUtils.cast((Object)map.get("headers"))).parameters((Map)ObjectUtils.cast((Object)map.get("parameters"))).characterEncoding((String)ObjectUtils.cast((Object)map.get("characterEncoding"))).languageTag((String)ObjectUtils.cast((Object)map.get("languageTag"))).languageTags(new HashSet((Collection)ObjectUtils.cast((Object)map.get("languageTags")))).secure(((Boolean)ObjectUtils.cast((Object)map.get("secure"))).booleanValue()).build();
    }

    private List<Cookie> buildCookies(Object obj) {
        List list = (List)ObjectUtils.cast((Object)obj);
        return list.stream().map(this::buildCookie).collect(Collectors.toList());
    }

    private Cookie buildCookie(Map<String, Object> map) {
        return Cookie.builder().comment((String)ObjectUtils.cast((Object)map.get("comment"))).domain((String)ObjectUtils.cast((Object)map.get("domain"))).maxAge(((Integer)ObjectUtils.cast((Object)map.get("maxAge"))).intValue()).path((String)ObjectUtils.cast((Object)map.get("path"))).secure(((Boolean)ObjectUtils.cast((Object)map.get("secure"))).booleanValue()).name((String)ObjectUtils.cast((Object)map.get("name"))).value((String)ObjectUtils.cast((Object)map.get("value"))).version(((Integer)ObjectUtils.cast((Object)map.get("version"))).intValue()).build();
    }
}

