/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.expansion.bpm;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.exception.ActiveDelegateException;
import com.huawei.yinglong.distributed.entity.ResultStatus;
import com.huawei.yinglong.distributed.expansion.entity.EvaluationActiveResult;
import com.huawei.yinglong.distributed.expansion.entity.EvaluationType;
import com.huawei.yinglong.distributed.expansion.entity.request.EvaluationParams;
import com.huawei.yinglong.distributed.expansion.util.EvaluationParamBuilder;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.rest.entity.Result;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.SubmitMultiTask;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.QueryHardwareEvaluationOverview;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.entity.MultiHardwareEvaluationOverview;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.Inspect;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.QueryInspectOverview;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.TaskOverviewDTO;
import org.camunda.bpm.client.spring.SpringTopicSubscription;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.spring.boot.starter.ClientProperties;
import org.camunda.bpm.client.spring.event.SubscriptionInitializedEvent;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.event.EventListener;

@Fitable
public class ExpansionEvaluationTask
implements JavaDelegate {
    private static final Logger log = LoggerFactory.getLogger(ExpansionEvaluationTask.class);
    protected String workerId;
    private final RuntimeService runtimeService;
    private final BpmContextService bpmContextService;
    @Fit(alias="queryInspectOverview\u7684\u5b9e\u73b0")
    private QueryInspectOverview storageExpansionOverview;
    @Fit(alias="queryHardwareEvaluationOverview\u7684\u5b9e\u73b0")
    private QueryHardwareEvaluationOverview hardwareEvaluationOverview;
    @Fit(alias="inspect\u7684\u5b9e\u73b0")
    private Inspect evaluationTask;
    @Fit(alias="executeMultiTask\u7684\u5b9e\u73b0")
    private SubmitMultiTask hardwareTask;

    public ExpansionEvaluationTask(ClientProperties properties, RuntimeService runtimeService, BpmContextService bpmContextService) {
        this.workerId = properties.getWorkerId();
        this.runtimeService = runtimeService;
        this.bpmContextService = bpmContextService;
    }

    public void execute(DelegateExecution delegateExecution) throws Exception {
        String executionId = delegateExecution.getId();
        EvaluationParams params = (EvaluationParams)this.bpmContextService.getContext(executionId, EvaluationParams.class);
        params.setTaskId(delegateExecution.getProcessInstanceId());
        if (params.isStorageOnly()) {
            this.handleResult((Response<String>)this.evaluationTask.process(EvaluationParamBuilder.buildStorageParam(params)));
            return;
        }
        if (params.isHardwareOnly()) {
            this.handleResult((Response<String>)this.hardwareTask.process(EvaluationParamBuilder.buildHardwareParam(params)));
            return;
        }
        this.handleResult((Response<String>)this.evaluationTask.process(EvaluationParamBuilder.buildStorageParam(params)));
        this.handleResult((Response<String>)this.hardwareTask.process(EvaluationParamBuilder.buildHardwareParam(params)));
    }

    @ExternalTaskSubscription(value="expansionOverview", lockDuration=2000L)
    @Bean
    public ExternalTaskHandler queryEvaluationDetail() {
        return (externalTask, externalTaskService) -> {
            String executionId = externalTask.getExecutionId();
            EvaluationParams params = (EvaluationParams)this.bpmContextService.getContext(executionId, EvaluationParams.class);
            params.setTaskId(externalTask.getProcessInstanceId());
            EvaluationActiveResult result = this.queryAndBuildActiveResult(externalTask, params);
            this.bpmContextService.updateActivityResult(executionId, (ActivityResult)result);
            this.bpmContextService.setProgress(executionId, (int)result.getProgress());
            this.updateActiveStatus(externalTask, externalTaskService, result);
        };
    }

    private EvaluationActiveResult queryAndBuildActiveResult(ExternalTask externalTask, EvaluationParams params) {
        EvaluationActiveResult result = params.isStorageOnly() ? this.buildStorageEvaluationDetail(externalTask) : (params.isHardwareOnly() ? this.buildHardwareDetail(externalTask) : this.buildEvaluationDetail(externalTask));
        return result;
    }

    private void updateActiveStatus(ExternalTask externalTask, ExternalTaskService externalTaskService, EvaluationActiveResult result) {
        ResultStatus status = result.getStatus();
        if (status.isSuccess()) {
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
            return;
        }
        if (status.isFailed()) {
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
            return;
        }
    }

    private EvaluationActiveResult buildEvaluationDetail(ExternalTask externalTask) {
        Response storage = this.storageExpansionOverview.process(externalTask.getProcessInstanceId());
        Response hardware = this.hardwareEvaluationOverview.process(externalTask.getProcessInstanceId());
        log.info("Storage overview : {} ,hardware overview : {} .", (Object)storage, (Object)hardware);
        return EvaluationActiveResult.buildActiveResult(EvaluationType.ALL, (TaskOverviewDTO)storage.getData(), (MultiHardwareEvaluationOverview)hardware.getData());
    }

    private EvaluationActiveResult buildHardwareDetail(ExternalTask externalTask) {
        Response hardware = this.hardwareEvaluationOverview.process(externalTask.getProcessInstanceId());
        log.info("Hardware overview : {} .", (Object)hardware);
        return EvaluationActiveResult.buildActiveResult(EvaluationType.HARDWARE, null, (MultiHardwareEvaluationOverview)hardware.getData());
    }

    private EvaluationActiveResult buildStorageEvaluationDetail(ExternalTask externalTask) {
        Response storage = this.storageExpansionOverview.process(externalTask.getProcessInstanceId());
        log.info("Storage overview : {} .", (Object)storage);
        return EvaluationActiveResult.buildActiveResult(EvaluationType.STORAGE, (TaskOverviewDTO)storage.getData(), null);
    }

    @EventListener(value={SubscriptionInitializedEvent.class})
    public void catchSubscriptionInitEvent(SubscriptionInitializedEvent event) {
        SpringTopicSubscription topicSubscription = event.getSource();
        if (!topicSubscription.isAutoOpen()) {
            topicSubscription.open();
            log.info("Subscription with topic name '{}' has been opened!", (Object)topicSubscription.getTopicName());
        }
    }

    private void handleResult(Response<String> response) throws Exception {
        if (response == null || response.getResult().getCode() == 0) {
            return;
        }
        Result result = response.getResult();
        throw new ActiveDelegateException(result.getCode().intValue(), result.getDescription(), result.getSuggestion());
    }
}

