/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.expansion.controller;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.yinglong.bpm.util.ResponseUtil;
import com.huawei.yinglong.distributed.expansion.entity.EvaluationType;
import com.huawei.yinglong.distributed.expansion.entity.request.ConfirmExpansionParams;
import com.huawei.yinglong.distributed.expansion.entity.request.ExportReportParam;
import com.huawei.yinglong.distributed.expansion.entity.request.ParseExpansionConfigParams;
import com.huawei.yinglong.drop.entity.item.entity.MultiRunningDetailDTO;
import com.huawei.yinglong.drop.entity.item.entity.ResultDetailDTO;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.storage.entity.MultiStroageNodeDto;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.ExportLldTemplate;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.ExportTemplate;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.ParseLldTemplateByType;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.MultiDeployTaskDetail;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.ParseDetail;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.QueryTaskDetailParam;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.QueryTaskDetail;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.ConfirmExpansionInfo;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.QueryDevice;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.QueryExpansionConfig;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.entity.MultiExpansionConfig;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.ExportReport;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.Inspect;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.QueryItemResultDetail;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.QueryItemRunningDetail;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/expansion/evaluation"})
public class ExpansionEvaluationController {
    private static final Logger log = LoggerFactory.getLogger(ExpansionEvaluationController.class);
    private static final String STORAGE_EVALUATION = "StorageEvaluation";
    private static final String HARDWARE_EVALUATION = "HardwareEvaluation";
    private static final String EXPANSION = "FsExpansion";
    @Fit(alias="exportLldTemplate\u7684\u5b9e\u73b0")
    private ExportLldTemplate exportLldTemplate;
    @Fit(alias="queryDevice\u7684\u5b9e\u73b0")
    private QueryDevice hardwareQueryImpl;
    @Fit(alias="parseLldTemplateByType\u7684\u5b9e\u73b0")
    private ParseLldTemplateByType parseLldTemplateByType;
    @Fit(alias="queryExpansionConfig\u7684\u5b9e\u73b0")
    private QueryExpansionConfig queryExpansionConfig;
    @Fit(alias="\u786c\u4ef6\u8bc4\u4f30\u786e\u8ba4\u8bc4\u4f30")
    private ConfirmExpansionInfo hardwareConfirmImpl;
    @Fit(alias="confirmExpansionInfo\u7684\u5b9e\u73b0")
    private ConfirmExpansionInfo confirmExpansionInfo;
    @Fit(alias="queryTaskDetail\u7684\u5b9e\u73b0")
    private QueryTaskDetail queryHardWareDetail;
    @Fit(alias="queryItemRunningDetail\u7684\u5b9e\u73b0")
    private QueryItemRunningDetail queryItemRunningDetail;
    @Fit(alias="queryItemResultDetail\u7684\u5b9e\u73b0")
    private QueryItemResultDetail queryItemResultDetail;
    @Fit(alias="queryDevice\u7684\u5b9e\u73b0")
    private com.huawei.yinglong.river.inspection.storage.distribution.inspect.QueryDevice storageQueryImpl;
    @Fit(alias="exportReport\u7684\u5b9e\u73b0")
    private ExportReport exportReport;
    @Fit(alias="inspect\u7684\u5b9e\u73b0")
    private Inspect evaluationTask;
    @Fit(alias="exportReport\u7684\u5b9e\u73b0")
    private com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.ExportReport hardwareReport;
    @Fit(alias="exportTemplate\u7684\u5b9e\u73b0")
    private ExportTemplate exportTemplate;

    @GetMapping(value={"devices"})
    public Response<MultiStroageNodeDto> queryCluster(String taskId, EvaluationType evaluationType) {
        if (evaluationType == EvaluationType.HARDWARE) {
            return this.hardwareQueryImpl.process(taskId);
        }
        return this.storageQueryImpl.process(taskId, EXPANSION);
    }

    @GetMapping(value={"storageEvaluationRunningDetail"})
    public Response<MultiRunningDetailDTO> queryStorageEvaluationRunningDetail(String taskId, String devId) {
        return this.queryItemRunningDetail.process(taskId, devId);
    }

    @GetMapping(value={"storageEvaluationResultDetail"})
    public Response<ResultDetailDTO> queryEvaluationResultDetail(String taskId, String devId, String itemId) {
        return this.queryItemResultDetail.process(taskId, devId, itemId);
    }

    @GetMapping(value={"hardwareDetail"})
    public Response<MultiDeployTaskDetail> queryHardwareEvaluationRunningDetail(String taskId, String devId) {
        QueryTaskDetailParam param = QueryTaskDetailParam.builder().taskId(String.join((CharSequence)"_", taskId, devId)).subTaskIds(Collections.singletonList("version_check")).build();
        return this.queryHardWareDetail.process(param);
    }

    @GetMapping(value={"expansionInfo"})
    public Response<MultiExpansionConfig> queryExpansionInfo(String taskId, String devId) {
        return this.queryExpansionConfig.process(String.join((CharSequence)"_", taskId, devId));
    }

    @PostMapping(value={"expansionConfig"})
    public Response<ParseDetail> parseExpansionConfig(@RequestBody ParseExpansionConfigParams params) {
        log.info("[expansion evaluation] start to parse evaluate config, params : {}.", (Object)params);
        Response response = this.parseLldTemplateByType.process(params.getId(), params.getConfigFile(), params.getScene(), params.getDevType());
        log.info("[expansion evaluation] end to parse evaluate config, result : {}.", (Object)response);
        return response;
    }

    @PostMapping(value={"confirmExpansionInfo"})
    public Response<String> confirmExpansionInfo(@RequestBody ConfirmExpansionParams params) {
        Response response;
        log.info("[expansion evaluation] start to confirm evaluate info, params : {}.", (Object)params);
        if (params.getEvaluationType().isHardware()) {
            response = this.hardwareConfirmImpl.process(params.getTaskId(), params.getDevId());
        } else if (params.getEvaluationType().isStorage()) {
            response = this.confirmExpansionInfo.process(params.getTaskId(), params.getDevId());
        } else {
            response = this.hardwareConfirmImpl.process(params.getTaskId(), params.getDevId());
            if (!ResponseUtil.isFailed((Response)response)) {
                response = this.confirmExpansionInfo.process(params.getTaskId(), params.getDevId());
            }
        }
        log.info("[expansion evaluation] end to confirm evaluate info, result : {}.", (Object)response);
        return response;
    }

    @GetMapping(value={"expansionTemplate"})
    public Response<String> exportLldTemplate(String targetDir) {
        log.info("[expansion evaluation] start to export lld template, targetDir : {}.", (Object)targetDir);
        Response response = this.exportLldTemplate.process(targetDir);
        log.info("[expansion evaluation] end to export lld template, result : {}.", (Object)response);
        return response;
    }

    @GetMapping(value={"exportTemplate"})
    public Response<String> exportTemplate(String targetDir, String scene) {
        log.info("[expansion evaluation] start to export template, targetDir : {}, scene : {}.", (Object)targetDir, (Object)scene);
        Response response = this.exportTemplate.process(targetDir, scene);
        log.info("[expansion evaluation] end to export template, result : {}.", (Object)response);
        return response;
    }

    @PostMapping(value={"report"})
    public Object exportReport(@RequestBody ExportReportParam param) {
        Response response;
        log.info("[expansion evaluation] start to export report, params : {}.", (Object)param);
        String baseDir = param.getTargetDir();
        Path storagePath = Paths.get(baseDir, STORAGE_EVALUATION);
        Path hardwarePath = Paths.get(baseDir, HARDWARE_EVALUATION);
        if (param.getEvaluationType() == EvaluationType.STORAGE) {
            response = this.exportReport.process(param.getTaskId(), storagePath.toString());
        } else if (param.getEvaluationType() == EvaluationType.HARDWARE) {
            response = this.hardwareReport.process(param.getTaskId(), hardwarePath.toString());
        } else {
            response = this.exportReport.process(param.getTaskId(), storagePath.toString());
            if (!ResponseUtil.isFailed((Response)response)) {
                response = this.hardwareReport.process(param.getTaskId(), hardwarePath.toString());
            }
            if (!ResponseUtil.isFailed((Response)response)) {
                response = ResponseUtil.success((Object)baseDir);
            }
        }
        log.info("[expansion evaluation] end to export report, result : {}.", (Object)response);
        return response;
    }
}

