/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.expansion.entity;

import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.distributed.entity.ResultStatus;
import com.huawei.yinglong.distributed.expansion.entity.EvaluationType;
import com.huawei.yinglong.distributed.expansion.entity.vo.ClusterEvaluationOverviewVo;
import com.huawei.yinglong.distributed.util.ProgressUtil;
import com.huawei.yinglong.drop.entity.task.entity.entity.TaskStatistics;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.entity.HardwareEvaluationOverview;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.entity.MultiHardwareEvaluationOverview;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.TaskOverviewDTO;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class EvaluationActiveResult
extends ActivityResult {
    private List<ClusterEvaluationOverviewVo> overviews;
    private TaskStatistics taskStatistics;
    private double progress;
    private ResultStatus status;

    public static EvaluationActiveResult buildActiveResult(EvaluationType evaluationType, TaskOverviewDTO storageOverview, MultiHardwareEvaluationOverview hardwareOverview) {
        if (evaluationType.isHardware()) {
            return EvaluationActiveResult.buildActiveResult(hardwareOverview);
        }
        if (evaluationType.isStorage()) {
            return EvaluationActiveResult.buildActiveResult(storageOverview);
        }
        return EvaluationActiveResult.buildMultiActiveResult(storageOverview, hardwareOverview);
    }

    private static EvaluationActiveResult buildMultiActiveResult(TaskOverviewDTO storageOverview, MultiHardwareEvaluationOverview hardwareOverview) {
        EvaluationActiveResult storage = EvaluationActiveResult.buildActiveResult(hardwareOverview);
        EvaluationActiveResult hardware = EvaluationActiveResult.buildActiveResult(storageOverview);
        List<EvaluationActiveResult> results = Arrays.asList(storage, hardware);
        List<ClusterEvaluationOverviewVo> overviewVos = EvaluationActiveResult.mergeEvaluationOverview(storageOverview, hardwareOverview);
        List<ResultStatus> statuses = EvaluationActiveResult.collectOverviewStatus(overviewVos);
        return ((EvaluationActiveResultBuilder)((Object)((EvaluationActiveResultBuilder)((Object)((EvaluationActiveResultBuilder)((Object)((EvaluationActiveResultBuilder)((Object)EvaluationActiveResult.builder().progress(ProgressUtil.averageProgress(EvaluationActiveResult.collectProgress(results))))).status(ResultStatus.merge(statuses)))).overviews(overviewVos))).taskStatistics(EvaluationActiveResult.builderTaskStatistics(statuses)))).build();
    }

    private static List<ResultStatus> collectOverviewStatus(List<ClusterEvaluationOverviewVo> overviewVos) {
        return overviewVos.stream().map(ClusterEvaluationOverviewVo::getStatus).map(status -> ResultStatus.of(status, ResultStatus.FAILED)).collect(Collectors.toList());
    }

    private static List<Double> collectProgress(List<EvaluationActiveResult> results) {
        return results.stream().map(EvaluationActiveResult::getProgress).collect(Collectors.toList());
    }

    private static List<ClusterEvaluationOverviewVo> mergeEvaluationOverview(TaskOverviewDTO storageOverview, MultiHardwareEvaluationOverview hardwareOverview) {
        Map hardwareTable = hardwareOverview.getHardwareEvaluationOverview().stream().collect(Collectors.toMap(HardwareEvaluationOverview::getIp, Function.identity()));
        return storageOverview.getOverviews().stream().map(view -> ClusterEvaluationOverviewVo.buildMergeClusterOverview(view, (HardwareEvaluationOverview)hardwareTable.get(view.getIp()))).collect(Collectors.toList());
    }

    private static EvaluationActiveResult buildActiveResult(TaskOverviewDTO storageOverview) {
        List<ClusterEvaluationOverviewVo> overviews = EvaluationActiveResult.buildOverviews(storageOverview);
        return ((EvaluationActiveResultBuilder)((Object)((EvaluationActiveResultBuilder)((Object)((EvaluationActiveResultBuilder)((Object)((EvaluationActiveResultBuilder)((Object)EvaluationActiveResult.builder().progress(storageOverview.getProgress()))).status(ResultStatus.of(storageOverview.getStatus(), ResultStatus.WAITED)))).overviews(overviews))).taskStatistics(EvaluationActiveResult.builderTaskStatistics(EvaluationActiveResult.collectOverviewStatus(overviews))))).build();
    }

    private static EvaluationActiveResult buildActiveResult(MultiHardwareEvaluationOverview hardwareOverview) {
        List<ClusterEvaluationOverviewVo> overviews = EvaluationActiveResult.buildOverviews(hardwareOverview);
        return ((EvaluationActiveResultBuilder)((Object)((EvaluationActiveResultBuilder)((Object)((EvaluationActiveResultBuilder)((Object)((EvaluationActiveResultBuilder)((Object)EvaluationActiveResult.builder().progress(hardwareOverview.getProgress()))).status(ResultStatus.of(hardwareOverview.getStatus(), ResultStatus.WAITED)))).overviews(overviews))).taskStatistics(EvaluationActiveResult.builderTaskStatistics(EvaluationActiveResult.collectOverviewStatus(overviews))))).build();
    }

    private static TaskStatistics builderTaskStatistics(List<ResultStatus> statuses) {
        return TaskStatistics.builder().successNum(Integer.valueOf((int)statuses.stream().filter(ResultStatus::isSuccess).count())).failedNum(Integer.valueOf((int)statuses.stream().filter(ResultStatus::isFailed).count())).noExecutedNum(Integer.valueOf((int)statuses.stream().filter(ResultStatus::isWaiting).count())).runningNum(Integer.valueOf((int)statuses.stream().filter(ResultStatus::isRunning).count())).build();
    }

    private static List<ClusterEvaluationOverviewVo> buildOverviews(TaskOverviewDTO storageOverview) {
        return storageOverview.getOverviews().stream().map(ClusterEvaluationOverviewVo::buildClusterOverview).collect(Collectors.toList());
    }

    private static List<ClusterEvaluationOverviewVo> buildOverviews(MultiHardwareEvaluationOverview hardwareOverview) {
        return hardwareOverview.getHardwareEvaluationOverview().stream().map(ClusterEvaluationOverviewVo::buildClusterOverview).collect(Collectors.toList());
    }

    protected EvaluationActiveResult(EvaluationActiveResultBuilder<?, ?> b) {
        super(b);
        this.overviews = ((EvaluationActiveResultBuilder)b).overviews;
        this.taskStatistics = ((EvaluationActiveResultBuilder)b).taskStatistics;
        this.progress = ((EvaluationActiveResultBuilder)b).progress;
        this.status = ((EvaluationActiveResultBuilder)b).status;
    }

    public static EvaluationActiveResultBuilder<?, ?> builder() {
        return new EvaluationActiveResultBuilderImpl();
    }

    public List<ClusterEvaluationOverviewVo> getOverviews() {
        return this.overviews;
    }

    public TaskStatistics getTaskStatistics() {
        return this.taskStatistics;
    }

    public double getProgress() {
        return this.progress;
    }

    public ResultStatus getStatus() {
        return this.status;
    }

    public void setOverviews(List<ClusterEvaluationOverviewVo> overviews) {
        this.overviews = overviews;
    }

    public void setTaskStatistics(TaskStatistics taskStatistics) {
        this.taskStatistics = taskStatistics;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public void setStatus(ResultStatus status) {
        this.status = status;
    }

    public EvaluationActiveResult() {
    }

    public EvaluationActiveResult(List<ClusterEvaluationOverviewVo> overviews, TaskStatistics taskStatistics, double progress, ResultStatus status) {
        this.overviews = overviews;
        this.taskStatistics = taskStatistics;
        this.progress = progress;
        this.status = status;
    }

    public String toString() {
        return "EvaluationActiveResult(overviews=" + this.getOverviews() + ", taskStatistics=" + this.getTaskStatistics() + ", progress=" + this.getProgress() + ", status=" + (Object)((Object)this.getStatus()) + ")";
    }

    private static final class EvaluationActiveResultBuilderImpl
    extends EvaluationActiveResultBuilder<EvaluationActiveResult, EvaluationActiveResultBuilderImpl> {
        private EvaluationActiveResultBuilderImpl() {
        }

        @Override
        protected EvaluationActiveResultBuilderImpl self() {
            return this;
        }

        @Override
        public EvaluationActiveResult build() {
            return new EvaluationActiveResult(this);
        }
    }

    public static abstract class EvaluationActiveResultBuilder<C extends EvaluationActiveResult, B extends EvaluationActiveResultBuilder<C, B>>
    extends ActivityResult.ActivityResultBuilder<C, B> {
        private List<ClusterEvaluationOverviewVo> overviews;
        private TaskStatistics taskStatistics;
        private double progress;
        private ResultStatus status;

        public B overviews(List<ClusterEvaluationOverviewVo> overviews) {
            this.overviews = overviews;
            return (B)this.self();
        }

        public B taskStatistics(TaskStatistics taskStatistics) {
            this.taskStatistics = taskStatistics;
            return (B)this.self();
        }

        public B progress(double progress) {
            this.progress = progress;
            return (B)this.self();
        }

        public B status(ResultStatus status) {
            this.status = status;
            return (B)this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "EvaluationActiveResult.EvaluationActiveResultBuilder(super=" + super.toString() + ", overviews=" + this.overviews + ", taskStatistics=" + this.taskStatistics + ", progress=" + this.progress + ", status=" + (Object)((Object)this.status) + ")";
        }
    }
}

