/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.expansion.entity.vo;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.huawei.yinglong.distributed.entity.ResultStatus;
import com.huawei.yinglong.distributed.util.ProgressUtil;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.entity.HardwareEvaluationOverview;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.CheckdDevOverviewDTO;
import java.util.Arrays;
import java.util.List;

@JsonDeserialize(builder=ClusterEvaluationOverviewVoBuilder.class)
public class ClusterEvaluationOverviewVo {
    private final String model;
    private final String hostName;
    private final String version;
    private final String sn;
    private final String ip;
    private final String status;
    private final double progress;

    public static ClusterEvaluationOverviewVo buildMergeClusterOverview(CheckdDevOverviewDTO storageOverView, HardwareEvaluationOverview hardwareOverview) {
        ClusterEvaluationOverviewVo.collectStatus(storageOverView, hardwareOverview);
        return ClusterEvaluationOverviewVo.builder().ip(storageOverView.getIp()).sn(storageOverView.getSn()).hostName(storageOverView.getHostName()).model(storageOverView.getModel()).version(storageOverView.getVersion()).progress(ProgressUtil.averageProgress(Arrays.asList(storageOverView.getProgress(), hardwareOverview.getProgress()))).status(ResultStatus.merge(ClusterEvaluationOverviewVo.collectStatus(storageOverView, hardwareOverview)).getKey()).build();
    }

    public static ClusterEvaluationOverviewVo buildClusterOverview(CheckdDevOverviewDTO storageOverView) {
        return ClusterEvaluationOverviewVo.builder().ip(storageOverView.getIp()).sn(storageOverView.getSn()).hostName(storageOverView.getHostName()).model(storageOverView.getModel()).version(storageOverView.getVersion()).progress(storageOverView.getProgress()).status(storageOverView.getStatus()).build();
    }

    public static ClusterEvaluationOverviewVo buildClusterOverview(HardwareEvaluationOverview hardwareOverview) {
        return ClusterEvaluationOverviewVo.builder().ip(hardwareOverview.getIp()).sn(hardwareOverview.getSn()).hostName(hardwareOverview.getHostName()).model(hardwareOverview.getModel()).version(hardwareOverview.getVersion()).progress(hardwareOverview.getProgress()).status(hardwareOverview.getStatus()).build();
    }

    private static List<ResultStatus> collectStatus(CheckdDevOverviewDTO storageOverView, HardwareEvaluationOverview hardwareOverview) {
        return Arrays.asList(ResultStatus.of(storageOverView.getStatus(), ResultStatus.WAITED), ResultStatus.of(hardwareOverview.getStatus(), ResultStatus.WAITED));
    }

    ClusterEvaluationOverviewVo(String model, String hostName, String version, String sn, String ip, String status, double progress) {
        this.model = model;
        this.hostName = hostName;
        this.version = version;
        this.sn = sn;
        this.ip = ip;
        this.status = status;
        this.progress = progress;
    }

    public static ClusterEvaluationOverviewVoBuilder builder() {
        return new ClusterEvaluationOverviewVoBuilder();
    }

    public String toString() {
        return "ClusterEvaluationOverviewVo(model=" + this.getModel() + ", hostName=" + this.getHostName() + ", version=" + this.getVersion() + ", sn=" + this.getSn() + ", ip=" + this.getIp() + ", status=" + this.getStatus() + ", progress=" + this.getProgress() + ")";
    }

    public String getModel() {
        return this.model;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSn() {
        return this.sn;
    }

    public String getIp() {
        return this.ip;
    }

    public String getStatus() {
        return this.status;
    }

    public double getProgress() {
        return this.progress;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class ClusterEvaluationOverviewVoBuilder {
        private String model;
        private String hostName;
        private String version;
        private String sn;
        private String ip;
        private String status;
        private double progress;

        ClusterEvaluationOverviewVoBuilder() {
        }

        public ClusterEvaluationOverviewVoBuilder model(String model) {
            this.model = model;
            return this;
        }

        public ClusterEvaluationOverviewVoBuilder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public ClusterEvaluationOverviewVoBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ClusterEvaluationOverviewVoBuilder sn(String sn) {
            this.sn = sn;
            return this;
        }

        public ClusterEvaluationOverviewVoBuilder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public ClusterEvaluationOverviewVoBuilder status(String status) {
            this.status = status;
            return this;
        }

        public ClusterEvaluationOverviewVoBuilder progress(double progress) {
            this.progress = progress;
            return this;
        }

        public ClusterEvaluationOverviewVo build() {
            return new ClusterEvaluationOverviewVo(this.model, this.hostName, this.version, this.sn, this.ip, this.status, this.progress);
        }

        public String toString() {
            return "ClusterEvaluationOverviewVo.ClusterEvaluationOverviewVoBuilder(model=" + this.model + ", hostName=" + this.hostName + ", version=" + this.version + ", sn=" + this.sn + ", ip=" + this.ip + ", status=" + this.status + ", progress=" + this.progress + ")";
        }
    }
}

