/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.expansion.util;

import com.huawei.yinglong.distributed.expansion.entity.request.EvaluationParams;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.ClusterEvaluationParams;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.MultiTaskParam;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.CheckDevParams;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.StartInspectParams;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class EvaluationParamBuilder {
    private static final String EXPANSION = "FsExpansion";
    public static final String CHECK = "version_check";

    public static MultiTaskParam buildHardwareParam(EvaluationParams params) {
        return MultiTaskParam.builder().taskId(params.getTaskId()).clusterParams(EvaluationParamBuilder.buildClusterEvaluationParams(params)).build();
    }

    private static List<ClusterEvaluationParams> buildClusterEvaluationParams(EvaluationParams params) {
        return params.getSelectedClusterIds().stream().map(clusterId -> ClusterEvaluationParams.builder().clusterId(clusterId).mappingVersion(params.getDeviceVersion().get(clusterId)).subTaskIds(params.isStorageOnly() ? Collections.emptyList() : Collections.singletonList(CHECK)).build()).collect(Collectors.toList());
    }

    public static StartInspectParams buildStorageParam(EvaluationParams params) {
        return StartInspectParams.builder().taskId(params.getTaskId()).checkDevParams(EvaluationParamBuilder.buildStorageEvaluationParams(params)).scene(EXPANSION).build();
    }

    private static List<CheckDevParams> buildStorageEvaluationParams(EvaluationParams params) {
        return EvaluationParamBuilder.buildClusterEvaluationParams(params).stream().map(EvaluationParamBuilder::buildStorageEvaluationParam).collect(Collectors.toList());
    }

    private static CheckDevParams buildStorageEvaluationParam(ClusterEvaluationParams params) {
        return CheckDevParams.builder().devId(params.getClusterId()).clusterNodeIds(Collections.emptyList()).itemIds(Collections.emptyList()).build();
    }
}

