/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.spring.config;

import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.List;
import java.util.Optional;
import org.springframework.core.env.Environment;

public interface CommandBuilder {
    public static final String KEY_VALUE_SEPARATOR = "=";

    public List<String> toArgs();

    public void accept(Environment var1);

    default public String buildRequiredArg(String key, String value) {
        Validation.notBlank((String)key, (String)"Arg key is blank.", (Object[])new Object[0]);
        Validation.notBlank((String)value, (String)"Arg value is blank. [key={0}]", (Object[])new Object[]{key});
        return key + KEY_VALUE_SEPARATOR + value;
    }

    default public Optional<String> buildOptionalArg(String key, String value) {
        Validation.notBlank((String)key, (String)"Arg key is blank.", (Object[])new Object[0]);
        return Optional.ofNullable(value).filter(StringUtils::isNotBlank).map(actualValue -> key + KEY_VALUE_SEPARATOR + actualValue);
    }

    default public Optional<String> getProperty(String property, Environment env) {
        String value = Optional.ofNullable(System.getProperty(property)).orElseGet(() -> env.getProperty(property));
        return Optional.ofNullable(value);
    }
}

